/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl;

import java.util.List;
import org.eclipse.draw2dl.AbstractHintLayout;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.geometry.Dimension;
import org.eclipse.draw2dl.geometry.Rectangle;

public class StackLayout
extends AbstractHintLayout {
    @Override
    protected Dimension calculateMinimumSize(IFigure figure, int wHint, int hHint) {
        if (wHint > -1) {
            wHint = Math.max(0, wHint - figure.getInsets().getWidth());
        }
        if (hHint > -1) {
            hHint = Math.max(0, hHint - figure.getInsets().getHeight());
        }
        Dimension d = new Dimension();
        List<IFigure> children = figure.getChildren();
        for (IFigure child : children) {
            if (this.isObservingVisibility() && !child.isVisible()) continue;
            d.union(child.getMinimumSize(wHint, hHint));
        }
        d.expand(figure.getInsets().getWidth(), figure.getInsets().getHeight());
        d.union(this.getBorderPreferredSize(figure));
        return d;
    }

    @Override
    protected Dimension calculatePreferredSize(IFigure figure, int wHint, int hHint) {
        if (wHint > -1) {
            wHint = Math.max(0, wHint - figure.getInsets().getWidth());
        }
        if (hHint > -1) {
            hHint = Math.max(0, hHint - figure.getInsets().getHeight());
        }
        Dimension d = new Dimension();
        List<IFigure> children = figure.getChildren();
        for (IFigure child : children) {
            if (this.isObservingVisibility() && !child.isVisible()) continue;
            d.union(child.getPreferredSize(wHint, hHint));
        }
        d.expand(figure.getInsets().getWidth(), figure.getInsets().getHeight());
        d.union(this.getBorderPreferredSize(figure));
        return d;
    }

    @Override
    public void layout(IFigure figure) {
        Rectangle r = figure.getClientArea();
        List<IFigure> children = figure.getChildren();
        for (IFigure child : children) {
            child.setBounds(r);
        }
    }
}

