/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl;

import org.eclipse.draw2dl.AbstractLayout;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.geometry.Dimension;

public abstract class AbstractHintLayout
extends AbstractLayout {
    private Dimension minimumSize = null;
    private Dimension cachedPreferredHint = new Dimension(-1, -1);
    private Dimension cachedMinimumHint = new Dimension(-1, -1);

    protected Dimension calculateMinimumSize(IFigure container, int wHint, int hHint) {
        return this.getPreferredSize(container, wHint, hHint);
    }

    @Override
    public Dimension getMinimumSize(IFigure container, int w, int h) {
        boolean flush = this.cachedMinimumHint.width != w && this.isSensitiveHorizontally(container);
        if (flush |= this.cachedMinimumHint.height != h && this.isSensitiveVertically(container)) {
            this.minimumSize = null;
            this.cachedMinimumHint.width = w;
            this.cachedMinimumHint.height = h;
        }
        if (this.minimumSize == null) {
            this.minimumSize = this.calculateMinimumSize(container, w, h);
        }
        return this.minimumSize;
    }

    @Override
    public final Dimension getPreferredSize(IFigure container, int w, int h) {
        boolean flush = this.cachedPreferredHint.width != w && this.isSensitiveHorizontally(container);
        if (flush |= this.cachedPreferredHint.height != h && this.isSensitiveVertically(container)) {
            this.preferredSize = null;
            this.cachedPreferredHint.width = w;
            this.cachedPreferredHint.height = h;
        }
        return super.getPreferredSize(container, w, h);
    }

    @Override
    public void invalidate() {
        this.minimumSize = null;
        super.invalidate();
    }

    protected boolean isSensitiveHorizontally(IFigure container) {
        return true;
    }

    protected boolean isSensitiveVertically(IFigure container) {
        return true;
    }
}

