/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;

public class ScanIterable
implements SdkIterable<ScanResponse> {
    private final DynamoDbClient client;
    private final ScanRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ScanIterable(DynamoDbClient client, ScanRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ScanResponseFetcher();
    }

    public Iterator<ScanResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Map<String, AttributeValue>> items() {
        Function<ScanResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ScanResponseFetcher
    implements SyncPageFetcher<ScanResponse> {
        private ScanResponseFetcher() {
        }

        public boolean hasNextPage(ScanResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.lastEvaluatedKey());
        }

        public ScanResponse nextPage(ScanResponse previousPage) {
            if (previousPage == null) {
                return ScanIterable.this.client.scan(ScanIterable.this.firstRequest);
            }
            return ScanIterable.this.client.scan((ScanRequest)((Object)ScanIterable.this.firstRequest.toBuilder().exclusiveStartKey(previousPage.lastEvaluatedKey()).build()));
        }
    }
}

