/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.asf.IfxDataInputStream;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxValue;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.IfxTypes;
import com.informix.util.IfxErrMsg;
import java.io.ByteArrayOutputStream;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Vector;

class IfxRowColumn {
    IfxConnection conn;
    ByteArrayOutputStream bStream;
    byte[] tuple;
    IfxResultSetMetaData rsmd;
    int offset;
    Vector<ColumnInfo> colInfoVector;
    private int initialSize;
    private int currDataSize;
    private boolean dataInStream;

    IfxRowColumn(IfxConnection thisConn, IfxResultSetMetaData metaData, int initialSize) throws SQLException {
        this.rsmd = metaData;
        this.conn = thisConn;
        try {
            this.initialSize = this.rsmd.hasVariableLengthColumns ? initialSize + 1024 : initialSize;
            this.tuple = new byte[this.initialSize];
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    IfxRowColumn(IfxConnection conn, IfxResultSetMetaData metaData) {
        this.conn = conn;
        this.rsmd = metaData;
    }

    void readTuple(IfxDataInputStream is, int offset, int size) throws SQLException {
        if (this.dataInStream || this.currDataSize + size > this.initialSize) {
            try {
                byte[] tmpTuple = new byte[size];
                if (!this.dataInStream) {
                    if (this.bStream == null) {
                        this.bStream = new ByteArrayOutputStream();
                    }
                    if (this.currDataSize > 0) {
                        this.bStream.write(this.tuple, 0, this.currDataSize);
                    }
                    this.dataInStream = true;
                }
                is.readPadded(tmpTuple, 0, size);
                this.bStream.write(tmpTuple, 0, size);
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
        try {
            is.readPadded(this.tuple, offset, size);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        this.currDataSize += size;
    }

    void setOffsetInTuple(int offset) throws SQLException {
        this.offset = offset;
        if (this.rsmd.hasVariableLengthColumns || this.rsmd.hasVariableLengthCharColumns) {
            int rowOffset = offset;
            int colOffset = 0;
            if (this.colInfoVector == null) {
                this.colInfoVector = new Vector();
                this.colInfoVector.setSize(this.rsmd.getColumnCount());
            }
            for (int i = 1; i <= this.rsmd.getColumnCount(); ++i) {
                int dataLen;
                byte[] b;
                int colType = this.rsmd.getIfxColumnType(i);
                int colLen = this.rsmd.getColumnLength(i);
                if (colType == 40 || colType == 41 || colType == 45 || colType == 43 || colType == 46) {
                    b = new byte[4];
                    if (this.dataInStream) {
                        this.tuple = this.bStream.toByteArray();
                        this.dataInStream = false;
                        this.bStream.reset();
                    }
                    System.arraycopy(this.tuple, rowOffset + 1, b, 0, 4);
                    dataLen = IfxToJavaType.IfxToJavaInt(b);
                    colLen = 5 + dataLen;
                } else if (colType == 13 || colType == 16) {
                    if (((IfxSqliConnect)this.conn).isVarcharVarLenSupported()) {
                        if (this.dataInStream) {
                            this.tuple = this.bStream.toByteArray();
                            this.dataInStream = false;
                            this.bStream.reset();
                        }
                        colLen = 1 + (this.tuple[rowOffset] & 0xFF);
                    } else {
                        ++colLen;
                    }
                } else if (IfxTypes.isComplexType(colType)) {
                    b = new byte[4];
                    if (this.dataInStream) {
                        this.tuple = this.bStream.toByteArray();
                        this.dataInStream = false;
                        this.bStream.reset();
                    }
                    System.arraycopy(this.tuple, rowOffset, b, 0, 4);
                    dataLen = IfxToJavaType.IfxToJavaInt(b);
                    colLen = dataLen + 4;
                }
                rowOffset += colLen;
                ColumnInfo ci = new ColumnInfo(colOffset, colLen);
                this.colInfoVector.setElementAt(ci, i - 1);
                colOffset += colLen;
            }
        }
    }

    void setMetaData(IfxResultSetMetaData metaData) {
        this.rsmd = metaData;
    }

    IfxObject getColumn(int idx) throws SQLException {
        return this.getColumn(idx, null);
    }

    IfxObject getColumn(int idx, Calendar cal) throws SQLException {
        IfxObject obj = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(idx), cal);
        this.loadColumnData(idx, obj);
        return obj;
    }

    void loadColumnData(int idx, IfxObject val) throws SQLException {
        byte[] thisTuple;
        int columnOffset;
        int ifxColLen;
        int columnType = this.rsmd.getIfxColumnType(idx);
        val.clear();
        if (this.colInfoVector != null) {
            if (idx > this.colInfoVector.size()) {
                throw IfxErrMsg.getSQLException(-79703, this.conn);
            }
            ColumnInfo ci = this.colInfoVector.get(idx - 1);
            ifxColLen = ci.len;
            columnOffset = ci.startPos;
            if (!(this.rsmd.hasVariableLengthColumns || columnType != 13 && columnType != 16)) {
                ++ifxColLen;
            }
        } else {
            IfxColumnInfo ifxColumnInfo = this.rsmd.getColumnInfo(idx);
            if (ifxColumnInfo.isIfxColLenSet) {
                ifxColLen = ifxColumnInfo.ifxColLen;
                columnOffset = ifxColumnInfo.ColStartPos;
            } else {
                columnOffset = this.rsmd.getColumnStartPosition(idx);
                switch (columnType) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 17: 
                    case 52: {
                        ifxColLen = 1;
                        break;
                    }
                    default: {
                        ifxColLen = this.rsmd.getColumnLength(idx);
                    }
                }
                if (!(this.rsmd.hasVariableLengthColumns || columnType != 13 && columnType != 16)) {
                    ++ifxColLen;
                }
                ifxColumnInfo.ifxColLen = ifxColLen;
                ifxColumnInfo.isIfxColLenSet = true;
            }
        }
        byte[] byArray = thisTuple = this.dataInStream ? this.bStream.toByteArray() : this.tuple;
        if (thisTuple != null && ifxColLen > 0) {
            try {
                switch (columnType) {
                    case 5: 
                    case 8: 
                    case 10: 
                    case 14: {
                        val.fromIfx(thisTuple, this.offset + columnOffset, ifxColLen, (short)this.rsmd.getEncodedLength(idx));
                        break;
                    }
                    default: {
                        val.fromIfx(thisTuple, this.offset + columnOffset, ifxColLen);
                        break;
                    }
                }
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
    }

    byte[] getTupleData() {
        if (!this.dataInStream) {
            return this.tuple;
        }
        return this.bStream.toByteArray();
    }

    void reset() {
        if (this.dataInStream) {
            this.dataInStream = false;
            this.bStream.reset();
        }
        this.currDataSize = 0;
    }

    void clear() {
        this.reset();
        this.rsmd = null;
    }

    int getInitialSize() {
        return this.initialSize;
    }

    class ColumnInfo {
        int startPos;
        int len;

        ColumnInfo(int startPos, int len) {
            this.startPos = startPos;
            this.len = len;
        }

        public String toString() {
            return "Position: " + this.startPos + "\tLength: " + this.len;
        }
    }
}

