/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.sql.plan.diagram.features;

import com.dbeaver.model.sql.plan.emf.SQLPlanNode;
import com.dbeaver.ui.editors.sql.plan.diagram.renders.PlanNodeRender;
import com.dbeaver.ui.editors.sql.plan.diagram.renders.PlanNodeRenderInfo;
import com.dbeaver.ui.editors.sql.plan.diagram.util.PlanDiagramUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramContainer;
import org.eclipse.graphiti.services.Graphiti;
import org.jkiss.dbeaver.ui.UIUtils;

public class PlansDetailInfoFeature
extends AbstractCustomFeature {
    public PlansDetailInfoFeature(IFeatureProvider fp) {
        super(fp);
    }

    public void execute(ICustomContext context) {
        SQLPlanNode node;
        PlanNodeRenderInfo renderInfo = PlanDiagramUtil.getRenderInfo(context);
        if (renderInfo == null) {
            return;
        }
        this.setDetailInfo(node, renderInfo, !(node = renderInfo.getNode()).isDetailsVisible());
        UIUtils.asyncExec(() -> {
            PlanDiagramUtil.layoutNodeWithsiblings(renderInfo);
            IDiagramContainer diagramContainer = (IDiagramContainer)node.getPlan().getOwnerPart().getContainerComposite();
            diagramContainer.selectPictogramElements(new PictogramElement[]{(PictogramElement)renderInfo.getNode().getContainer()});
        });
    }

    public String getDescription() {
        return "Detail plan node info";
    }

    public String getName() {
        return "Detail";
    }

    public boolean canExecute(ICustomContext context) {
        return true;
    }

    public boolean isAvailable(IContext context) {
        return super.isAvailable(context);
    }

    public String getImageId() {
        return super.getImageId();
    }

    public void setDetailInfo(SQLPlanNode node, PlanNodeRenderInfo renderInfo, boolean detailInfo) {
        if (renderInfo == null) {
            return;
        }
        GraphicsAlgorithm nodeShape = renderInfo.getShape().getParentGraphicsAlgorithm();
        node.setDetailsVisible(detailInfo);
        PlanNodeRender nodeRender = new PlanNodeRender(renderInfo);
        nodeRender.computeSize();
        Graphiti.getGaService().setSize(nodeShape, nodeRender.getNodeWidth(), nodeRender.getNodeHeight());
        this.layoutPictogramElement((PictogramElement)renderInfo.getContainerShape());
        nodeRender.render();
    }
}

