/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.importer;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.local.LocalStatement;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferUtils;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataImporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.StreamDataImporterColumnInfo;
import org.jkiss.dbeaver.tools.transfer.stream.StreamEntityMapping;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferResultSet;
import org.jkiss.dbeaver.tools.transfer.stream.importer.StreamImporterAbstract;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.jkiss.utils.xml.XMLException;
import org.xml.sax.Attributes;

public class DataImporterXML
extends StreamImporterAbstract {
    private static final Log log = Log.getLog(DataImporterXML.class);
    private static final String PROP_DATA_FORMAT = "dataFormat";
    private static final int MAX_COLUMN_LENGTH = 1024;
    private boolean delimHasName;
    private String rowDelimiterName;

    @NotNull
    public List<StreamDataImporterColumnInfo> readColumnsInfo(final StreamEntityMapping entityMapping, @NotNull InputStream inputStream) throws DBException {
        final ArrayList<StreamDataImporterColumnInfo> columnsInfo = new ArrayList<StreamDataImporterColumnInfo>();
        Map processorProperties = this.getSite().getProcessorProperties();
        CommonUtils.toString(processorProperties.get(PROP_DATA_FORMAT));
        SAXReader parser = new SAXReader(inputStream);
        try {
            parser.parse(new SAXListener(){
                int tagIndex = 0;
                int columnIndex = 0;
                String columnName;
                private StringBuilder textBuffer = new StringBuilder();

                public void saxStartElement(SAXReader reader, String namespaceURI, String localName, Attributes atts) throws XMLException {
                    if (this.tagIndex == 1 && !DataImporterXML.this.delimHasName) {
                        DataImporterXML.this.rowDelimiterName = localName;
                        DataImporterXML.this.delimHasName = true;
                        ++this.tagIndex;
                    } else if (this.tagIndex > 1) {
                        this.columnName = localName;
                    } else if (!DataImporterXML.this.delimHasName) {
                        ++this.tagIndex;
                    }
                }

                public void saxText(SAXReader reader, String data) throws XMLException {
                    if (this.columnName != null) {
                        this.textBuffer.append(data);
                    }
                }

                public void saxEndElement(SAXReader reader, String namespaceURI, String localName) throws XMLException {
                    String tagData = this.textBuffer.toString();
                    if (this.columnName != null) {
                        String typeName = "VARCHAR";
                        DBPDataKind dataKind = DBPDataKind.STRING;
                        if (!CommonUtils.isEmpty((String)tagData)) {
                            Pair dataType = DatabaseTransferUtils.getDataType((String)tagData);
                            typeName = (String)dataType.getSecond();
                            dataKind = (DBPDataKind)dataType.getFirst();
                        }
                        StreamDataImporterColumnInfo columnInfo = new StreamDataImporterColumnInfo(entityMapping, this.columnIndex, this.columnName, typeName, 1024, dataKind);
                        columnsInfo.add(columnInfo);
                        ++this.columnIndex;
                        this.columnName = null;
                        this.textBuffer.setLength(0);
                    } else if (localName.equals(DataImporterXML.this.rowDelimiterName)) {
                        throw new StopSAXParserException("Parsing finished.");
                    }
                }
            });
        }
        catch (StopSAXParserException stopSAXParserException) {
        }
        catch (Exception exception) {
            log.debug((Object)"Can't read column names from XML file.");
        }
        return columnsInfo;
    }

    public void runImport(final @NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource streamDataSource, @NotNull InputStream inputStream, final @NotNull IDataTransferConsumer consumer) throws DBException {
        IStreamDataImporterSite site = this.getSite();
        StreamEntityMapping entityMapping = site.getSourceObject();
        Map processorProperties = this.getSite().getProcessorProperties();
        CommonUtils.toString(processorProperties.get(PROP_DATA_FORMAT));
        DBCExecutionContext context = streamDataSource.getDefaultInstance().getDefaultContext(monitor, false);
        Throwable throwable = null;
        Object var10_11 = null;
        try (final DBCSession producerSession = context.openSession(monitor, DBCExecutionPurpose.UTIL, "Transfer stream data");){
            LocalStatement localStatement = new LocalStatement(producerSession, "SELECT * FROM Stream");
            final StreamTransferResultSet resultSet = new StreamTransferResultSet(producerSession, (DBCStatement)localStatement, entityMapping);
            consumer.fetchStart(producerSession, (DBCResultSet)resultSet, -1L, -1L);
            SAXReader parser = new SAXReader(inputStream);
            try {
                try {
                    final ArrayList resultsList = new ArrayList();
                    parser.parse(new SAXListener(){
                        StringBuilder textBuffer = new StringBuilder();
                        int tagIndex = 0;
                        int rowNumber;

                        public void saxStartElement(SAXReader reader, String namespaceURI, String localName, Attributes atts) throws XMLException {
                            this.textBuffer.setLength(0);
                            if (this.tagIndex == 1) {
                                DataImporterXML.this.rowDelimiterName = localName;
                                DataImporterXML.this.delimHasName = true;
                                ++this.tagIndex;
                            } else if (!DataImporterXML.this.delimHasName) {
                                ++this.tagIndex;
                            }
                        }

                        public void saxText(SAXReader reader, String data) throws XMLException {
                            this.textBuffer.append(data);
                        }

                        public void saxEndElement(SAXReader reader, String namespaceURI, String localName) throws XMLException {
                            if (!localName.equals(DataImporterXML.this.rowDelimiterName)) {
                                String data = this.textBuffer.toString();
                                resultsList.add(data);
                            } else {
                                resultSet.setStreamRow(resultsList.toArray());
                                try {
                                    consumer.fetchRow(producerSession, (DBCResultSet)resultSet);
                                }
                                catch (DBCException e) {
                                    log.debug((Object)"Error reading data from XML file.", (Throwable)e);
                                }
                                resultsList.clear();
                                monitor.worked(1);
                                if (this.rowNumber % 1000 == 0) {
                                    monitor.subTask(String.valueOf(this.rowNumber) + " rows processed");
                                }
                                ++this.rowNumber;
                            }
                        }
                    });
                }
                catch (Exception e) {
                    DBWorkbench.getPlatformUI().showError("XML parse error", "Can't parse given XML file:\n" + e.getMessage());
                    log.debug((Object)"Import cannot be done from XML file.", (Throwable)e);
                    try {
                        consumer.fetchEnd(producerSession, (DBCResultSet)resultSet);
                    }
                    finally {
                        consumer.close();
                    }
                }
            }
            finally {
                try {
                    consumer.fetchEnd(producerSession, (DBCResultSet)resultSet);
                }
                finally {
                    consumer.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public class StopSAXParserException
    extends XMLException {
        StopSAXParserException(String message) {
            super(message);
        }
    }
}

