/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb.exec;

import com.dbeaver.ee.influxdb.exec.InfluxExecutionContext;
import com.dbeaver.ee.influxdb.exec.InfluxSelectStatement;
import com.dbeaver.ee.influxdb.model.InfluxDataSource;
import org.influxdb.InfluxDB;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.impl.AbstractSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class InfluxSession
extends AbstractSession {
    private static final Log log = Log.getLog(InfluxSession.class);
    private final InfluxExecutionContext executionContext;

    public InfluxSession(DBRProgressMonitor monitor, DBCExecutionPurpose purpose, String taskTitle, InfluxExecutionContext executionContext) {
        super(monitor, purpose, taskTitle);
        this.executionContext = executionContext;
    }

    @NotNull
    public InfluxExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @NotNull
    public InfluxDataSource getDataSource() {
        return (InfluxDataSource)this.executionContext.getDataSource();
    }

    @NotNull
    public DBCStatement prepareStatement(@NotNull DBCStatementType type, @NotNull String query, boolean scrollable, boolean updatable, boolean returnGeneratedKeys) throws DBCException {
        query = query.trim();
        return new InfluxSelectStatement(this, null, query);
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        throw new DBCFeatureNotSupportedException();
    }

    public void close() {
        super.close();
    }

    public InfluxDB getInfluxDB() {
        return this.executionContext.getInfluxDB();
    }
}

