/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.qmdb.ui.search;

import com.dbeaver.ee.qmdb.ui.search.SearchQueriesParams;
import com.dbeaver.ee.qmdb.ui.search.SearchQueriesQuery;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomTimeEditor;
import org.jkiss.dbeaver.ui.search.AbstractSearchPage;
import org.jkiss.utils.CommonUtils;

public class SearchQueriesPage
extends AbstractSearchPage {
    private static final String PROP_SEARCH_STRING = "search.string";
    private static final String PROP_CASE_SENSITIVE = "search.case-sensitive";
    private static final String PROP_HISTORY = "search.query.history";
    private Combo searchText;
    private SearchQueriesParams params = new SearchQueriesParams();
    private Set<String> searchHistory = new LinkedHashSet<String>();
    private DBPPreferenceStore store;

    public SearchQueriesPage() {
        super("SQL queries search");
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.initializeDialogUnits((Control)parent);
        Composite searchGroup = new Composite(parent, 0);
        searchGroup.setLayoutData((Object)new GridData(1808));
        searchGroup.setLayout((Layout)new GridLayout(3, false));
        this.setControl((Control)searchGroup);
        UIUtils.createControlLabel((Composite)searchGroup, (String)"SQL string");
        this.searchText = new Combo(searchGroup, 4);
        this.searchText.setLayoutData((Object)new GridData(768));
        if (this.params.searchString != null) {
            this.searchText.setText(this.params.searchString);
        }
        for (String history : this.searchHistory) {
            this.searchText.add(history);
        }
        this.searchText.addModifyListener(e -> {
            this.params.searchString = this.searchText.getText();
            this.updateEnablement();
        });
        SashForm optionsGroup = new SashForm(searchGroup, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        optionsGroup.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        optionsGroup.setLayoutData((Object)gd);
        Group optionsGroup2 = UIUtils.createControlGroup((Composite)optionsGroup, (String)"Settings", (int)2, (int)768, (int)0);
        optionsGroup2.setLayoutData((Object)new GridData(802));
        UIUtils.createControlLabel((Composite)optionsGroup2, (String)"From time");
        CustomTimeEditor fromTime = new CustomTimeEditor((Composite)optionsGroup2, 2048, false, false);
        fromTime.setValue(new Date(0L));
        UIUtils.createControlLabel((Composite)optionsGroup2, (String)"To time");
        CustomTimeEditor toTime = new CustomTimeEditor((Composite)optionsGroup2, 2048, false, false);
        toTime.setValue(new Date());
        this.updateEnablement();
    }

    public SearchQueriesQuery createQuery() throws DBException {
        if (!this.searchHistory.contains(this.params.searchString)) {
            this.searchHistory.add(this.params.searchString);
            this.searchText.add(this.params.searchString);
        }
        return SearchQueriesQuery.createQuery(this.params);
    }

    public void loadState(DBPPreferenceStore store) {
        String history;
        this.params.searchString = store.getString(PROP_SEARCH_STRING);
        this.params.caseSensitive = store.getBoolean(PROP_CASE_SENSITIVE);
        int i = 0;
        while (!CommonUtils.isEmpty((String)(history = store.getString("search.query.history." + i)))) {
            this.searchHistory.add(history);
            ++i;
        }
        this.store = store;
    }

    public void saveState(DBPPreferenceStore store) {
        store.setValue(PROP_SEARCH_STRING, this.params.searchString);
        store.setValue(PROP_CASE_SENSITIVE, this.params.caseSensitive);
        int historyIndex = 0;
        for (String history : this.searchHistory) {
            if (historyIndex >= 20) break;
            store.setValue("search.query.history." + historyIndex, history);
            ++historyIndex;
        }
    }

    protected void updateEnablement() {
        boolean enabled = false;
        if (!CommonUtils.isEmpty((String)this.params.searchString)) {
            enabled = true;
        }
        this.container.setPerformActionEnabled(enabled);
    }
}

