/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cassandra.exec;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.dbeaver.db.cassandra.exec.CasBaseStatement;
import com.dbeaver.db.cassandra.exec.CasSession;
import java.util.concurrent.TimeUnit;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.utils.CommonUtils;

public class CasSimpleStatement
extends CasBaseStatement {
    private Statement builtStatement;

    public CasSimpleStatement(CasSession session, String query) {
        super(session, query);
        this.builtStatement = new SimpleStatement(query);
        this.builtStatement.setConsistencyLevel(session.getExecutionContext().getCurrentConsistencyLevel());
        if (CommonUtils.toBoolean((Object)session.getDataSource().getContainer().getConnectionConfiguration().getProviderProperty("@dbeaver-enable.query.trace@"))) {
            this.builtStatement.enableTracing();
        }
    }

    @Override
    public Statement getStatementImpl() {
        return this.builtStatement;
    }

    public boolean executeStatement() throws DBCException {
        if (this.session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        this.startBlock("Execute statement");
        try {
            Session sessionImpl = this.session.getImpl();
            long timeoutMs = this.statementTimeout * 1000;
            if (timeoutMs > 0L) {
                this.builtStatement.setReadTimeoutMillis((int)timeoutMs);
            }
            this.resultSetFuture = sessionImpl.executeAsync(this.builtStatement);
            try {
                this.result = timeoutMs > 0L ? (ResultSet)this.resultSetFuture.get(timeoutMs, TimeUnit.SECONDS) : (ResultSet)this.resultSetFuture.get();
            }
            finally {
                this.resultSetFuture = null;
            }
            ColumnDefinitions resultColumns = this.result.getColumnDefinitions();
            if (resultColumns == null || resultColumns.size() == 0) {
                this.result = null;
            }
            boolean bl = this.result != null;
            return bl;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.endBlock();
            if (this.session.isLoggingEnabled()) {
                QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, -1L, this.executeError);
            }
        }
    }
}

