/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cassandra.edit;

import com.dbeaver.db.cassandra.model.CasTable;
import com.dbeaver.db.cassandra.model.CasTableIndex;
import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndexColumn;
import org.jkiss.utils.CommonUtils;

public class CasIndexManager
extends SQLObjectEditor<CasTableIndex, CasTable> {
    public boolean canCreateObject(Object container) {
        return true;
    }

    public boolean canDeleteObject(CasTableIndex object) {
        return true;
    }

    protected CasTableIndex createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) throws DBException {
        return new CasTableIndex((CasTable)container, "new_index", false);
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) throws DBException {
        CasTableIndex index = (CasTableIndex)command.getObject();
        boolean custom = index.isCustom();
        StringBuilder sql = new StringBuilder("CREATE ");
        if (custom) {
            sql.append("CUSTOM ");
        }
        sql.append("INDEX ").append(DBUtils.getQuotedIdentifier((DBSObject)index)).append(" ON ").append(DBUtils.getObjectFullName((DBPNamedObject)index.getTable(), (DBPEvaluationContext)DBPEvaluationContext.DDL)).append(" (");
        boolean firstColumn = true;
        for (DBSTableIndexColumn indexColumn : CommonUtils.safeCollection(index.getAttributeReferences(monitor))) {
            if (!firstColumn) {
                sql.append(",");
            }
            sql.append(DBUtils.getQuotedIdentifier((DBSObject)indexColumn));
            firstColumn = false;
        }
        sql.append(")");
        String indexClassName = index.getIndexClassName();
        if (custom && CommonUtils.isNotEmpty((String)indexClassName)) {
            sql.append(" USING ").append(SQLUtils.quoteString((DBPDataSource)index.getDataSource(), (String)indexClassName));
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create index", sql.toString()));
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) throws DBException {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop index", "DROP INDEX " + ((CasTableIndex)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL)));
    }

    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, CasTableIndex> getObjectsCache(CasTableIndex object) {
        return object.getTable().getIndexCache();
    }
}

