/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.vertica.model;

import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericSQLDialect;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.sql.SQLExpressionFormatter;

public class VerticaSQLDialect
extends GenericSQLDialect {
    private static final String[][] VERTICA_BEGIN_END_BLOCK = new String[][]{{"BEGIN", "END"}, {"CASE", "END"}};
    private static String[] VERTICA_KEYWORDS = new String[]{"BIT", "CACHE", "COMMENT", "CORRELATION", "ENCODED", "FLEX", "ILIKE", "ILIKEB", "INTERVALYM", "ISNULL", "KSAFE", "LIKEB", "MINUS", "MONEY", "NCHAR", "NOTNULL", "NULLSEQUAL", "OFFSET", "PINNED", "PROJECTION", "SMALLDATETIME", "TEXT", "TIMESERIES", "TIMEZONE", "TINYINT", "UUID", "VARCHAR2"};
    private static String[] VERTICA_FUNCTIONS = new String[]{"CURRENT_DATABASE", "CURRENT_SCHEMA", "DATEDIFF", "DATETIME", "DECODE"};

    public VerticaSQLDialect() {
        super("Vertica", "vertica");
    }

    public void initDriverSettings(JDBCSession session, JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(session, dataSource, metaData);
        this.addSQLKeywords(Arrays.asList(VERTICA_KEYWORDS));
        this.addFunctions(Arrays.asList(VERTICA_FUNCTIONS));
    }

    public boolean supportsAliasInSelect() {
        return true;
    }

    public String[][] getIdentifierQuoteStrings() {
        return BasicSQLDialect.DEFAULT_IDENTIFIER_QUOTES;
    }

    @Nullable
    public SQLExpressionFormatter getCaseInsensitiveExpressionFormatter(@NotNull DBCLogicalOperator operator) {
        if (operator == DBCLogicalOperator.LIKE) {
            return (left, right) -> String.valueOf(left) + " ILIKE " + right;
        }
        return super.getCaseInsensitiveExpressionFormatter(operator);
    }

    public String[][] getBlockBoundStrings() {
        return VERTICA_BEGIN_END_BLOCK;
    }

    public boolean supportsInsertAllDefaultValuesStatement() {
        return true;
    }
}

