/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

public class PostgreAuthPgPassConfigurator
implements IObjectPropertyConfigurator<Object, DBPDataSourceContainer> {
    protected Text usernameText;

    public void createControl(@NotNull Composite authPanel, Object object, @NotNull Runnable propertyChangeListener) {
        int fontHeight = UIUtils.getFontHeight((Control)authPanel);
        Label usernameLabel = UIUtils.createLabel((Composite)authPanel, (String)UIConnectionMessages.dialog_connection_auth_label_username);
        usernameLabel.setLayoutData((Object)new GridData(32));
        this.usernameText = new Text(authPanel, 2048);
        GridData gd = new GridData(32);
        gd.widthHint = fontHeight * 20;
        this.usernameText.setLayoutData((Object)gd);
        this.usernameText.addModifyListener(e -> propertyChangeListener.run());
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSource) {
        this.usernameText.setText(CommonUtils.notEmpty((String)dataSource.getConnectionConfiguration().getUserName()));
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSource) {
        dataSource.getConnectionConfiguration().setUserName(this.usernameText.getText());
        dataSource.setSavePassword(true);
    }

    public void resetSettings(@NotNull DBPDataSourceContainer dataSource) {
        this.loadSettings(dataSource);
    }

    public boolean isComplete() {
        return true;
    }
}

