/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.view;

import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.view.OnError;
import com.couchbase.client.java.view.Stale;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Arrays;

public class SpatialViewQuery
implements Serializable {
    private static final long serialVersionUID = -2743654475987033659L;
    private static final int PARAM_LIMIT_OFFSET = 0;
    private static final int PARAM_SKIP_OFFSET = 2;
    private static final int PARAM_STALE_OFFSET = 4;
    private static final int PARAM_DEBUG_OFFSET = 6;
    private static final int PARAM_START_RANGE_OFFSET = 8;
    private static final int PARAM_END_RANGE_OFFSET = 10;
    private static final int PARAM_ONERROR_OFFSET = 12;
    private static final int NUM_PARAMS = 7;
    private final String[] params;
    private final String design;
    private final String view;
    private boolean development;
    private boolean includeDocs;
    private Class<? extends Document<?>> includeDocsTarget;

    private SpatialViewQuery(String design, String view) {
        this.design = design;
        this.view = view;
        this.params = new String[14];
        this.includeDocs = false;
        this.includeDocsTarget = null;
    }

    public static SpatialViewQuery from(String design, String view) {
        return new SpatialViewQuery(design, view);
    }

    public SpatialViewQuery development() {
        return this.development(true);
    }

    public SpatialViewQuery development(boolean development) {
        this.development = development;
        return this;
    }

    public SpatialViewQuery includeDocs() {
        return this.includeDocs(true, JsonDocument.class);
    }

    public SpatialViewQuery includeDocs(Class<? extends Document<?>> target) {
        return this.includeDocs(true, target);
    }

    public SpatialViewQuery includeDocs(boolean includeDocs) {
        return this.includeDocs(includeDocs, JsonDocument.class);
    }

    public SpatialViewQuery includeDocs(boolean includeDocs, Class<? extends Document<?>> target) {
        this.includeDocs = includeDocs;
        this.includeDocsTarget = target;
        return this;
    }

    public SpatialViewQuery limit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("Limit must be >= 0.");
        }
        this.params[0] = "limit";
        this.params[1] = Integer.toString(limit);
        return this;
    }

    public SpatialViewQuery skip(int skip) {
        if (skip < 0) {
            throw new IllegalArgumentException("Skip must be >= 0.");
        }
        this.params[2] = "skip";
        this.params[3] = Integer.toString(skip);
        return this;
    }

    public SpatialViewQuery stale(Stale stale) {
        this.params[4] = "stale";
        this.params[5] = stale.identifier();
        return this;
    }

    public SpatialViewQuery debug() {
        return this.debug(true);
    }

    public SpatialViewQuery debug(boolean debug) {
        this.params[6] = "debug";
        this.params[7] = Boolean.toString(debug);
        return this;
    }

    public SpatialViewQuery startRange(JsonArray startRange) {
        this.params[8] = "start_range";
        this.params[9] = startRange.toString();
        return this;
    }

    public SpatialViewQuery endRange(JsonArray endRange) {
        this.params[10] = "end_range";
        this.params[11] = endRange.toString();
        return this;
    }

    public SpatialViewQuery range(JsonArray startRange, JsonArray endRange) {
        this.startRange(startRange);
        this.endRange(endRange);
        return this;
    }

    public SpatialViewQuery onError(OnError onError) {
        this.params[12] = "on_error";
        this.params[13] = onError.identifier();
        return this;
    }

    protected String encode(String source) {
        try {
            return URLEncoder.encode(source, "UTF-8");
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not prepare view argument: " + ex);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean firstParam = true;
        for (int i = 0; i < this.params.length; ++i) {
            boolean even;
            if (this.params[i] == null) {
                ++i;
                continue;
            }
            boolean bl = even = i % 2 == 0;
            if (even && !firstParam) {
                sb.append("&");
            }
            sb.append(this.params[i]);
            firstParam = false;
            if (!even) continue;
            sb.append('=');
        }
        return sb.toString();
    }

    public String getDesign() {
        return this.design;
    }

    public String getView() {
        return this.view;
    }

    public boolean isDevelopment() {
        return this.development;
    }

    public boolean isIncludeDocs() {
        return this.includeDocs;
    }

    public Class<? extends Document<?>> includeDocsTarget() {
        return this.includeDocsTarget;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpatialViewQuery query = (SpatialViewQuery)o;
        if (this.development != query.development) {
            return false;
        }
        if (this.design != null ? !this.design.equals(query.design) : query.design != null) {
            return false;
        }
        if (!Arrays.equals(this.params, query.params)) {
            return false;
        }
        return !(this.view != null ? !this.view.equals(query.view) : query.view != null);
    }

    public int hashCode() {
        int result = this.params != null ? Arrays.hashCode(this.params) : 0;
        result = 31 * result + (this.design != null ? this.design.hashCode() : 0);
        result = 31 * result + (this.view != null ? this.view.hashCode() : 0);
        result = 31 * result + (this.development ? 1 : 0);
        return result;
    }
}

