/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.view;

import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.util.Blocking;
import com.couchbase.client.java.view.AsyncSpatialViewRow;
import com.couchbase.client.java.view.SpatialViewRow;
import java.util.concurrent.TimeUnit;

public class DefaultSpatialViewRow
implements SpatialViewRow {
    private static final TimeUnit TIMEOUT_UNIT = TimeUnit.MILLISECONDS;
    private final AsyncSpatialViewRow asyncViewRow;
    private final long timeout;

    public DefaultSpatialViewRow(CouchbaseEnvironment env, AsyncSpatialViewRow asyncViewRow) {
        this.asyncViewRow = asyncViewRow;
        this.timeout = env.kvTimeout();
    }

    @Override
    public String id() {
        return this.asyncViewRow.id();
    }

    @Override
    public JsonArray key() {
        return this.asyncViewRow.key();
    }

    @Override
    public Object value() {
        return this.asyncViewRow.value();
    }

    @Override
    public JsonObject geometry() {
        return this.asyncViewRow.geometry();
    }

    @Override
    public JsonDocument document() {
        return this.document(this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public JsonDocument document(long timeout, TimeUnit timeUnit) {
        return (JsonDocument)Blocking.blockForSingle(this.asyncViewRow.document().singleOrDefault(null), timeout, timeUnit);
    }

    @Override
    public <D extends Document<?>> D document(Class<D> target) {
        return this.document(target, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public <D extends Document<?>> D document(Class<D> target, long timeout, TimeUnit timeUnit) {
        return (D)((Document)Blocking.blockForSingle(this.asyncViewRow.document(target).singleOrDefault(null), timeout, timeUnit));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultSpatialViewRow{");
        sb.append("id=").append(this.id());
        sb.append(", key=").append(this.key());
        sb.append(", value=").append(this.value());
        sb.append(", geometry=").append(this.geometry());
        sb.append('}');
        return sb.toString();
    }
}

