/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.util;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.ReplicaMode;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.JsonDocument;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Single;
import rx.functions.Func1;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class TransparentReplicaGetHelper {
    @InterfaceStability.Experimental
    @InterfaceAudience.Public
    public Single<JsonDocument> getFirstPrimaryOrReplica(String id, Bucket bucket, long primaryTimeout, long replicaTimeout) {
        return TransparentReplicaGetHelper.getFirstPrimaryOrReplica(id, JsonDocument.class, bucket, primaryTimeout, replicaTimeout);
    }

    @InterfaceStability.Experimental
    @InterfaceAudience.Public
    public Single<JsonDocument> getFirstPrimaryOrReplica(String id, Bucket bucket, long timeout) {
        return this.getFirstPrimaryOrReplica(id, bucket, timeout, timeout);
    }

    @InterfaceStability.Experimental
    @InterfaceAudience.Public
    public Single<JsonDocument> getFirstPrimaryOrReplica(String id, Bucket bucket) {
        return this.getFirstPrimaryOrReplica(id, bucket, bucket.environment().kvTimeout());
    }

    @InterfaceStability.Experimental
    @InterfaceAudience.Public
    public static <D extends Document<?>> Single<D> getFirstPrimaryOrReplica(String id, Class<D> target, Bucket bucket) {
        return TransparentReplicaGetHelper.getFirstPrimaryOrReplica(id, target, bucket, bucket.environment().kvTimeout());
    }

    @InterfaceStability.Experimental
    @InterfaceAudience.Public
    public static <D extends Document<?>> Single<D> getFirstPrimaryOrReplica(String id, Class<D> target, Bucket bucket, long timeout) {
        return TransparentReplicaGetHelper.getFirstPrimaryOrReplica(id, target, bucket, timeout, timeout);
    }

    @InterfaceStability.Experimental
    @InterfaceAudience.Public
    public static <D extends Document<?>> Single<D> getFirstPrimaryOrReplica(String id, Class<D> target, Bucket bucket, long primaryTimeout, long replicaTimeout) {
        if (primaryTimeout <= 0L) {
            throw new IllegalArgumentException("Primary timeout must be greater than 0ms");
        }
        if (replicaTimeout <= 0L) {
            throw new IllegalArgumentException("Replica timeout must be greater than 0ms");
        }
        Observable fallback = bucket.async().getFromReplica(id, ReplicaMode.ALL, target).timeout(replicaTimeout, TimeUnit.MILLISECONDS).firstOrDefault(null).filter(new Func1<D, Boolean>(){

            public Boolean call(D d) {
                return d != null;
            }
        });
        return bucket.async().get(id, target).timeout(primaryTimeout, TimeUnit.MILLISECONDS).onErrorResumeNext(fallback).toSingle();
    }
}

