/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.result.hits;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import java.util.Arrays;

@InterfaceStability.Uncommitted
@InterfaceAudience.Public
public class HitLocation {
    private final String field;
    private final String term;
    private final long pos;
    private final long start;
    private final long end;
    private final long[] arrayPositions;

    public HitLocation(String field, String term, long pos, long start, long end, long[] arrayPositions) {
        this.field = field;
        this.term = term;
        this.pos = pos;
        this.start = start;
        this.end = end;
        this.arrayPositions = arrayPositions;
    }

    public HitLocation(String field, String term, long pos, long start, long end) {
        this(field, term, pos, start, end, null);
    }

    public String field() {
        return this.field;
    }

    public String term() {
        return this.term;
    }

    public long pos() {
        return this.pos;
    }

    public long start() {
        return this.start;
    }

    public long end() {
        return this.end;
    }

    public long[] arrayPositions() {
        return this.arrayPositions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HitLocation that = (HitLocation)o;
        if (this.pos != that.pos) {
            return false;
        }
        if (this.start != that.start) {
            return false;
        }
        if (this.end != that.end) {
            return false;
        }
        if (!this.field.equals(that.field)) {
            return false;
        }
        if (!this.term.equals(that.term)) {
            return false;
        }
        return Arrays.equals(this.arrayPositions, that.arrayPositions);
    }

    public int hashCode() {
        int result = this.field.hashCode();
        result = 31 * result + this.term.hashCode();
        result = 31 * result + (int)(this.pos ^ this.pos >>> 32);
        result = 31 * result + (int)(this.start ^ this.start >>> 32);
        result = 31 * result + (int)(this.end ^ this.end >>> 32);
        result = 31 * result + Arrays.hashCode(this.arrayPositions);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("HitLocation{").append("field='").append(this.field).append('\'').append(", term='").append(this.term).append('\'').append(", pos=").append(this.pos).append(", start=").append(this.start).append(", end=").append(this.end);
        if (this.arrayPositions != null) {
            sb.append(", arrayPositions=").append(Arrays.toString(this.arrayPositions));
        }
        sb.append('}');
        return sb.toString();
    }
}

