/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.analytics;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.analytics.AnalyticsDeferredResultHandle;
import com.couchbase.client.java.analytics.AnalyticsMetrics;
import com.couchbase.client.java.analytics.AnalyticsQueryResult;
import com.couchbase.client.java.analytics.AnalyticsQueryRow;
import com.couchbase.client.java.analytics.AsyncAnalyticsDeferredResultHandle;
import com.couchbase.client.java.analytics.AsyncAnalyticsQueryRow;
import com.couchbase.client.java.analytics.DefaultAnalyticsDeferredResultHandle;
import com.couchbase.client.java.analytics.DefaultAnalyticsQueryRow;
import com.couchbase.client.java.document.json.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@InterfaceStability.Committed
@InterfaceAudience.Public
public class DefaultAnalyticsQueryResult
implements AnalyticsQueryResult {
    private String status;
    private final boolean finalSuccess;
    private final boolean parseSuccess;
    private List<AnalyticsQueryRow> allRows;
    private final Object signature;
    private final AnalyticsMetrics info;
    private final List<JsonObject> errors;
    private final String requestId;
    private final String clientContextId;
    private final AsyncAnalyticsDeferredResultHandle asyncHandle;
    private final AnalyticsDeferredResultHandle handle;

    public DefaultAnalyticsQueryResult(List<AsyncAnalyticsQueryRow> rows, Object signature, AnalyticsMetrics info, List<JsonObject> errors, String finalStatus, Boolean finalSuccess, boolean parseSuccess, String requestId, String clientContextId) {
        this.requestId = requestId;
        this.clientContextId = clientContextId;
        this.parseSuccess = parseSuccess;
        this.finalSuccess = finalSuccess != null && finalSuccess != false;
        this.status = finalStatus;
        this.allRows = new ArrayList<AnalyticsQueryRow>(rows.size());
        for (AsyncAnalyticsQueryRow row : rows) {
            this.allRows.add(new DefaultAnalyticsQueryRow(row));
        }
        this.signature = signature;
        this.errors = errors;
        this.info = info;
        this.handle = null;
        this.asyncHandle = null;
    }

    public DefaultAnalyticsQueryResult(AsyncAnalyticsDeferredResultHandle asyncHandle, Object signature, AnalyticsMetrics info, List<JsonObject> errors, String finalStatus, Boolean finalSuccess, boolean parseSuccess, String requestId, String clientContextId) {
        this.asyncHandle = asyncHandle;
        this.handle = new DefaultAnalyticsDeferredResultHandle(this.asyncHandle);
        this.requestId = requestId;
        this.clientContextId = clientContextId;
        this.parseSuccess = parseSuccess;
        this.finalSuccess = finalSuccess != null && finalSuccess != false;
        this.status = finalStatus;
        this.signature = signature;
        this.errors = errors;
        this.info = info;
    }

    @Override
    public List<AnalyticsQueryRow> allRows() {
        if (this.status.equalsIgnoreCase("running")) {
            return null;
        }
        return this.allRows;
    }

    @Override
    public Iterator<AnalyticsQueryRow> rows() {
        if (this.status.equalsIgnoreCase("running")) {
            return null;
        }
        return this.allRows().iterator();
    }

    @Override
    public Object signature() {
        return this.signature;
    }

    @Override
    public AnalyticsMetrics info() {
        return this.info;
    }

    @Override
    public boolean parseSuccess() {
        return this.parseSuccess;
    }

    @Override
    public List<JsonObject> errors() {
        return this.errors;
    }

    @Override
    public boolean finalSuccess() {
        return this.finalSuccess;
    }

    @Override
    public String status() {
        return this.status;
    }

    @Override
    public Iterator<AnalyticsQueryRow> iterator() {
        return this.rows();
    }

    @Override
    public String requestId() {
        return this.requestId;
    }

    @Override
    public String clientContextId() {
        return this.clientContextId;
    }

    @Override
    public AnalyticsDeferredResultHandle handle() {
        return this.handle;
    }

    public String toString() {
        return "DefaultAnalyticsQueryResult{status='" + this.status + '\'' + ", finalSuccess=" + this.finalSuccess + ", parseSuccess=" + this.parseSuccess + ", allRows=" + this.allRows + ", signature=" + this.signature + ", info=" + this.info + ", errors=" + this.errors + ", requestId='" + this.requestId + '\'' + ", clientContextId='" + this.clientContextId + '\'' + ", handle='" + this.handle + '\'' + '}';
    }
}

