/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.vertica.model;

import java.sql.ResultSet;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericFunctionResultType;
import org.jkiss.dbeaver.ext.generic.model.GenericPackage;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPOverloadedObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.utils.CommonUtils;

public class VerticaFunction
extends GenericProcedure
implements DBPOverloadedObject {
    private final String USER_DEFINED_FUNCTION = "User Defined Function";
    private final String functionType;
    private final String functionDefinition;
    private final String volatility;
    private final boolean isStrict;
    private final boolean isFenced;
    private String description;
    private final String funcReturnType;
    private final String funcArgumentType;

    public VerticaFunction(GenericStructContainer container, String functionName, String description, ResultSet dbResult) {
        super(container, functionName, null, description, DBSProcedureType.FUNCTION, null);
        this.functionType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"procedure_type");
        this.functionDefinition = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"function_definition");
        this.volatility = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"volatility");
        this.isStrict = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"is_strict");
        this.isFenced = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"is_fenced");
        this.funcReturnType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"function_return_type");
        this.funcArgumentType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"function_argument_type");
        this.description = description;
    }

    public GenericCatalog getCatalog() {
        return super.getCatalog();
    }

    public GenericFunctionResultType getFunctionResultType() {
        return null;
    }

    public GenericPackage getPackage() {
        return super.getPackage();
    }

    @Property(viewable=true, order=8)
    public String getFunctionType() {
        return this.functionType;
    }

    @Property(viewable=true, order=9)
    public String getVolatility() {
        return this.volatility;
    }

    @Property(viewable=true, order=10)
    public boolean isStrict() {
        return this.isStrict;
    }

    @Property(viewable=true, order=11)
    public boolean isFenced() {
        return this.isFenced;
    }

    @Property(viewable=true, length=PropertyLength.MULTILINE, editable=true, updatable=true, order=12)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if ("User Defined Function".equals(this.functionType)) {
            StringBuilder definition = new StringBuilder();
            definition.append("CREATE OR REPLACE FUNCTION ").append(this.getFullyQualifiedName(DBPEvaluationContext.DDL)).append("(");
            if (CommonUtils.isNotEmpty((String)this.funcArgumentType)) {
                definition.append(this.funcArgumentType);
            }
            definition.append(") RETURN ").append(this.funcReturnType).append("\nAS BEGIN\n\t").append(this.functionDefinition).append(";\nEND");
            return definition.toString();
        }
        return this.functionDefinition;
    }

    @NotNull
    public String getOverloadedName() {
        return String.valueOf(this.getName()) + "(" + this.funcArgumentType + ")";
    }
}

