/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.netezza.model;

import com.dbeaver.db.netezza.model.NetezzaDataSourceExt;
import com.dbeaver.db.netezza.model.NetezzaGenericDatabase;
import com.dbeaver.db.netezza.model.NetezzaGenericTable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBAUser;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSStructContainer;
import org.jkiss.utils.CommonUtils;

public class NetezzaUser
implements DBAUser,
DBSStructContainer {
    private String userName;
    private final NetezzaDataSourceExt dataSource;
    private final NetezzaGenericDatabase database;
    private String owner;
    private Date validUntil;
    private Date createDate;
    private long rowLimit;
    private long sessionTimeout;
    private long queryTimeout;
    private long sysID;
    private long passwordExpiry;
    private PriorityType defPriority;
    private PriorityType maxPriority;
    private boolean expirePassword;
    private String userPassword;
    private NetezzaUserTablesCache netezzaUserTablesCache;

    public NetezzaUser(@NotNull String userName, @NotNull NetezzaDataSourceExt dataSource, @NotNull NetezzaGenericDatabase database, JDBCResultSet dbResult) {
        this.userName = userName;
        this.dataSource = dataSource;
        this.database = database;
        if (dbResult != null) {
            this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNER");
            this.validUntil = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"VALIDUNTIL");
            this.createDate = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATEDATE");
            this.rowLimit = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"ROWLIMIT");
            this.sessionTimeout = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"SESSIONTIMEOUT");
            this.queryTimeout = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"QUERYTIMEOUT");
            this.sysID = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"USESYSID");
            this.passwordExpiry = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"PWD_EXPIRY");
            String defPriorityS = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DEF_PRIORITY");
            this.defPriority = (PriorityType)CommonUtils.valueOf(PriorityType.class, (String)defPriorityS);
            String maxPriorityS = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"MAX_PRIORITY");
            this.maxPriority = (PriorityType)CommonUtils.valueOf(PriorityType.class, (String)maxPriorityS);
            this.expirePassword = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"PWD_INVALID");
        }
    }

    @NotNull
    public NetezzaGenericDatabase getParentObject() {
        return this.database;
    }

    @NotNull
    public NetezzaDataSourceExt getDataSource() {
        return this.dataSource;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Property(viewable=true, order=2)
    public String getOwner() {
        return this.owner;
    }

    @Property(viewable=true, order=3)
    public Date getValidUntil() {
        return this.validUntil;
    }

    @Property(viewable=true, order=4)
    public Date getCreateDate() {
        return this.createDate;
    }

    @Property(viewable=true, updatable=true, editable=true, order=5)
    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    @Property(viewable=true, updatable=true, editable=true, order=6)
    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    @Property(viewable=true, updatable=true, editable=true, order=7)
    public long getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(long queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    @Property(viewable=true, order=8)
    public long getSysID() {
        return this.sysID;
    }

    @Property(viewable=true, order=9)
    public long getPasswordExpiry() {
        return this.passwordExpiry;
    }

    @Property(viewable=true, updatable=true, editable=true, order=10)
    public PriorityType getDefPriority() {
        return this.defPriority;
    }

    public void setDefPriority(PriorityType defPriority) {
        this.defPriority = defPriority;
    }

    @Property(viewable=true, updatable=true, editable=true, order=11)
    public PriorityType getMaxPriority() {
        return this.maxPriority;
    }

    public void setMaxPriority(PriorityType maxPriority) {
        this.maxPriority = maxPriority;
    }

    @Property(viewable=true, order=12)
    public boolean isExpirePassword() {
        return this.expirePassword;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return true;
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.netezzaUserTablesCache == null) {
            this.netezzaUserTablesCache = new NetezzaUserTablesCache();
        }
        return this.netezzaUserTablesCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Nullable
    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        if (this.netezzaUserTablesCache == null) {
            this.netezzaUserTablesCache = new NetezzaUserTablesCache();
        }
        return this.netezzaUserTablesCache.getObject(monitor, (DBSObject)this, childName);
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return NetezzaGenericTable.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        this.netezzaUserTablesCache.getAllObjects(monitor, (DBSObject)this);
    }

    private class NetezzaUserTablesCache
    extends JDBCObjectCache<NetezzaUser, GenericTableBase> {
        private NetezzaUserTablesCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull NetezzaUser netezzaUser) throws SQLException {
            String sql = "SELECT VT.TABLENAME AS TABLE_NAME, VT.SCHEMA AS TABLE_SCHEM\n\tFROM " + DBUtils.getQuotedIdentifier((DBSObject)NetezzaUser.this.getParentObject()) + ".DEFINITION_SCHEMA._V_TABLE VT \n" + "\tWHERE VT.OWNER=?\n" + "UNION ALL\n" + "SELECT VV.VIEWNAME AS TABLE_NAME, VV.SCHEMA AS TABLE_SCHEM\n" + "\tFROM " + DBUtils.getQuotedIdentifier((DBSObject)NetezzaUser.this.getParentObject()) + ".DEFINITION_SCHEMA._V_VIEW VV\n" + "\tWHERE VV.OWNER=?";
            JDBCPreparedStatement dbStat = session.prepareStatement(sql);
            dbStat.setString(1, NetezzaUser.this.getName());
            dbStat.setString(2, NetezzaUser.this.getName());
            return dbStat;
        }

        @Nullable
        protected GenericTableBase fetchObject(@NotNull JDBCSession session, @NotNull NetezzaUser netezzaUser, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            String tableName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"TABLE_NAME");
            if (CommonUtils.isNotEmpty((String)tableName)) {
                DBRProgressMonitor monitor = session.getProgressMonitor();
                String schemaName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"TABLE_SCHEM");
                if (CommonUtils.isNotEmpty((String)schemaName)) {
                    GenericSchema schema = NetezzaUser.this.getParentObject().getSchema(monitor, schemaName);
                    if (schema != null) {
                        return schema.getTable(monitor, tableName);
                    }
                } else {
                    DBSObject child = NetezzaUser.this.getParentObject().getChild(monitor, tableName);
                    if (child instanceof GenericTableBase) {
                        return (GenericTableBase)child;
                    }
                }
            }
            return null;
        }
    }

    public static enum PriorityType {
        CRITICAL,
        HIGH,
        NORMAL,
        LOW,
        NONE;

    }
}

