/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.netezza.model;

import com.dbeaver.db.netezza.model.NetezzaDataSourceExt;
import com.dbeaver.db.netezza.model.NetezzaGenericDatabase;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.ForeignKeyInfo;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.DBPOverloadedObject;
import org.jkiss.dbeaver.model.DBPScriptObjectExt2;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.IPropertyCacheValidator;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyGroup;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.ByteNumberFormat;
import org.jkiss.utils.CommonUtils;

public class NetezzaGenericTable
extends GenericTable
implements DBPObjectStatistics,
DBPScriptObjectExt2,
DBPOverloadedObject {
    private static final Log log = Log.getLog(NetezzaGenericTable.class);
    private String tableType;
    private Date createDate;
    private String owner;
    private String schema;
    private boolean hasStatistics;
    private int blockSize;
    private long allocatedBlocks;
    private long allocatedBytes;
    private long allocatedAvg;
    private long usedBlocks;
    private long usedBytes;
    private long usedMin;
    private long usedMax;
    private long usedSpread;
    private boolean hideSchemas;
    private final AdditionalInfo additionalInfo = new AdditionalInfo();

    public NetezzaGenericTable(@NotNull GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        super(container, tableName, tableType, dbResult);
        this.hideSchemas = container instanceof NetezzaGenericDatabase;
        this.tableType = tableType;
        if (dbResult != null) {
            this.createDate = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATEDATE");
            this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNER");
            this.schema = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_SCHEM");
        }
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return super.getObjectDefinitionText(monitor, options);
    }

    public void addAttribute(GenericTableColumn column) {
        super.addAttribute(column);
    }

    protected boolean isCacheDDL() {
        return false;
    }

    public boolean supportsObjectDefinitionOption(String option) {
        return "ddl.includeComments".equals(option);
    }

    public List<ForeignKeyInfo> loadReferenceInfoList(@NotNull JDBCSession session, GenericMetaObject fkObject) throws SQLException {
        ArrayList<ForeignKeyInfo> fkInfos = new ArrayList<ForeignKeyInfo>();
        Throwable throwable = null;
        Object var5_6 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT RELATION AS FKTABLE_NAME, CONSTRAINTNAME AS FK_NAME,\nPKDATABASE AS PKTABLE_CAT, PKSCHEMA AS PKTABLE_SCHEM, PKRELATION AS PKTABLE_NAME,\nDATABASE AS FKTABLE_CAT, SCHEMA AS FKTABLE_SCHEM, CONSEQ AS KEY_SEQ,\nUPDT_TYPE AS UPDATE_RULE, DEL_TYPE AS DELETE_RULE, DEFERRABLECONSTR AS DEFERRABILITY, REFCONSTRNAME AS PK_NAME, PKATTNAME AS PKCOLUMN_NAME, ATTNAME AS FKCOLUMN_NAME FROM " + DBUtils.getQuotedIdentifier((DBSObject)this.getCatalog()) + ".DEFINITION_SCHEMA._V_RELATION_KEYDATA\n" + "WHERE CONTYPE='f'" + " AND SCHEMA=?" + " AND PKRELATION=?");){
            dbStat.setString(1, this.getSchemaName());
            dbStat.setString(2, this.getName());
            Throwable throwable2 = null;
            Object var8_11 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (dbResult.next()) {
                    ForeignKeyInfo fkInfo = new ForeignKeyInfo();
                    fkInfo.fetchColumnsInfo(fkObject, dbResult);
                    fkInfos.add(fkInfo);
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return fkInfos;
    }

    public boolean isSystem() {
        return this.tableType.equals("SYSTEM TABLE") || this.tableType.equals("MANAGEMENT TABLE");
    }

    @Property(viewable=true, order=7)
    public Date getCreateDate() {
        return this.createDate;
    }

    @Property(viewable=true, order=8)
    public String getOwner() {
        return this.owner;
    }

    public String getSchemaName() {
        String schemaName = this.hideSchemas ? DBUtils.getQuotedIdentifier((DBPDataSource)this.getDataSource(), (String)this.schema) : this.getSchema().getName();
        return schemaName;
    }

    public boolean hasStatistics() {
        return this.hasStatistics;
    }

    public long getStatObjectSize() {
        return this.usedBytes;
    }

    @Property(category="Statistics", viewable=false, order=20, formatter=ByteNumberFormat.class)
    public int getBlockSize(DBRProgressMonitor monitor) {
        this.readStatistics(monitor);
        return this.blockSize;
    }

    @Property(category="Statistics", viewable=false, order=21)
    public long getAllocatedBlocks(DBRProgressMonitor monitor) {
        this.readStatistics(monitor);
        return this.allocatedBlocks;
    }

    @Property(category="Statistics", viewable=true, order=22, formatter=ByteNumberFormat.class)
    public long getAllocatedBytes(DBRProgressMonitor monitor) {
        this.readStatistics(monitor);
        return this.allocatedBytes;
    }

    @Property(category="Statistics", viewable=false, order=23, formatter=ByteNumberFormat.class)
    public long getAllocatedAvg(DBRProgressMonitor monitor) {
        this.readStatistics(monitor);
        return this.allocatedAvg;
    }

    @Property(category="Statistics", viewable=false, order=24)
    public long getUsedBlocks(DBRProgressMonitor monitor) {
        this.readStatistics(monitor);
        return this.usedBlocks;
    }

    @Property(category="Statistics", viewable=true, order=25, formatter=ByteNumberFormat.class)
    public long getUsedBytes(DBRProgressMonitor monitor) {
        this.readStatistics(monitor);
        return this.usedBytes;
    }

    @Property(category="Statistics", viewable=false, order=26)
    public long getUsedMin(DBRProgressMonitor monitor) {
        this.readStatistics(monitor);
        return this.usedMin;
    }

    @Property(category="Statistics", viewable=false, order=27)
    public long getUsedMax(DBRProgressMonitor monitor) {
        this.readStatistics(monitor);
        return this.usedMax;
    }

    @Property(category="Statistics", viewable=false, order=28)
    public long getUsedSpread(DBRProgressMonitor monitor) {
        this.readStatistics(monitor);
        return this.usedSpread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PropertyGroup
    @LazyProperty(cacheValidator=AdditionalInfoValidator.class)
    public AdditionalInfo getAdditionalInfo(DBRProgressMonitor monitor) throws DBException {
        AdditionalInfo additionalInfo = this.additionalInfo;
        synchronized (additionalInfo) {
            if (!this.additionalInfo.loaded && monitor != null) {
                this.readAdditionalInfo(monitor);
            }
            return this.additionalInfo;
        }
    }

    @NotNull
    public String getOverloadedName() {
        if (((NetezzaDataSourceExt)this.getDataSource()).showOwnerNamesForTables() && CommonUtils.isNotEmpty((String)this.owner)) {
            return String.valueOf(DBUtils.getQuotedIdentifier((DBPDataSource)this.getDataSource(), (String)this.owner)) + "." + DBUtils.getQuotedIdentifier((DBSObject)this);
        }
        if (this.hideSchemas) {
            return String.valueOf(DBUtils.getQuotedIdentifier((DBPDataSource)this.getDataSource(), (String)this.getSchemaName())) + "." + DBUtils.getQuotedIdentifier((DBSObject)this);
        }
        return this.getName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readAdditionalInfo(DBRProgressMonitor monitor) throws DBCException {
        if (!this.isPersisted()) {
            this.additionalInfo.loaded = true;
            return;
        }
        monitor.beginTask("Selecting AdditionalInfo", 2);
        try {
            Throwable throwable2 = null;
            Object var3_4 = null;
            try {
                JDBCResultSet dbResult;
                Object var10_20;
                Throwable throwable;
                JDBCPreparedStatement stmt;
                Object var7_13;
                String sql;
                JDBCSession session;
                block47: {
                    session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read Table Details");
                    monitor.subTask("Selecting organizedOn");
                    sql = this.getDistOrgInfoTableQuery("_V_TABLE_ORGANIZE_COLUMN");
                    try {
                        Throwable throwable3 = null;
                        var7_13 = null;
                        try {
                            stmt = session.prepareStatement(sql);
                            try {
                                stmt.setString(1, this.getName());
                                stmt.setString(2, this.getSchemaName());
                                throwable = null;
                                var10_20 = null;
                                try {
                                    dbResult = stmt.executeQuery();
                                    try {
                                        String org = this.getAttributeFromResultSet(dbResult);
                                        this.additionalInfo.organizedOn = org.isEmpty() ? null : org;
                                    }
                                    finally {
                                        if (dbResult != null) {
                                            dbResult.close();
                                        }
                                    }
                                }
                                catch (Throwable throwable4) {
                                    if (throwable == null) {
                                        throwable = throwable4;
                                        throw throwable;
                                    }
                                    if (throwable == throwable4) throw throwable;
                                    throwable.addSuppressed(throwable4);
                                    throw throwable;
                                }
                            }
                            finally {
                                if (stmt != null) {
                                    stmt.close();
                                }
                            }
                        }
                        catch (Throwable throwable5) {
                            if (throwable3 == null) {
                                throwable3 = throwable5;
                                throw throwable3;
                            }
                            if (throwable3 == throwable5) throw throwable3;
                            throwable3.addSuppressed(throwable5);
                            throw throwable3;
                        }
                    }
                    catch (SQLException e) {
                        throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
                    }
                    monitor.worked(1);
                    if (!monitor.isCanceled()) break block47;
                    if (session == null) return;
                    session.close();
                    return;
                }
                try {
                    monitor.subTask("Selecting distributeOn");
                    sql = this.getDistOrgInfoTableQuery("_V_TABLE_DIST_MAP");
                    try {
                        Throwable e = null;
                        var7_13 = null;
                        try {
                            stmt = session.prepareStatement(sql);
                            try {
                                stmt.setString(1, this.getName());
                                stmt.setString(2, this.getSchemaName());
                                throwable = null;
                                var10_20 = null;
                                try {
                                    dbResult = stmt.executeQuery();
                                    try {
                                        String distr = this.getAttributeFromResultSet(dbResult);
                                        this.additionalInfo.distributeOn = distr.isEmpty() ? "RANDOM" : distr;
                                    }
                                    finally {
                                        if (dbResult != null) {
                                            dbResult.close();
                                        }
                                    }
                                }
                                catch (Throwable throwable6) {
                                    if (throwable == null) {
                                        throwable = throwable6;
                                        throw throwable;
                                    }
                                    if (throwable == throwable6) throw throwable;
                                    throwable.addSuppressed(throwable6);
                                    throw throwable;
                                }
                            }
                            finally {
                                if (stmt != null) {
                                    stmt.close();
                                }
                            }
                        }
                        catch (Throwable throwable7) {
                            if (e == null) {
                                e = throwable7;
                                throw e;
                            }
                            if (e == throwable7) throw e;
                            e.addSuppressed(throwable7);
                            throw e;
                        }
                    }
                    catch (SQLException e) {
                        throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
                    }
                    monitor.worked(1);
                }
                finally {
                    if (session != null) {
                        session.close();
                    }
                }
            }
            catch (Throwable throwable9) {
                if (throwable2 == null) {
                    throwable2 = throwable9;
                    throw throwable2;
                }
                if (throwable2 == throwable9) throw throwable2;
                throwable2.addSuppressed(throwable9);
                throw throwable2;
            }
        }
        finally {
            monitor.done();
        }
        this.additionalInfo.loaded = true;
    }

    private String getDistOrgInfoTableQuery(String sysTableName) {
        StringBuilder sql = new StringBuilder(256);
        sql.append("SELECT ATTNAME FROM ");
        GenericCatalog catalog = this.getCatalog();
        if (catalog != null) {
            sql.append(DBUtils.getQuotedIdentifier((DBSObject)catalog)).append(".");
        }
        sql.append("DEFINITION_SCHEMA.");
        sql.append(sysTableName).append(" WHERE TABLENAME = ? AND SCHEMA = ?");
        return sql.toString();
    }

    @NotNull
    private String getAttributeFromResultSet(@NotNull JDBCResultSet dbResult) throws SQLException {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        while (dbResult.next()) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ATTNAME"));
        }
        return sb.toString();
    }

    @Nullable
    public DBPPropertySource getStatProperties() {
        return null;
    }

    private void readStatistics(DBRProgressMonitor monitor) {
        if (this.hasStatistics) {
            return;
        }
        try {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (DBCSession session = DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read table statistics");){
                    Throwable throwable2 = null;
                    Object var6_10 = null;
                    try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement("SELECT * from " + DBUtils.getQuotedIdentifier((DBSObject)this.getCatalog()) + ".DEFINITION_SCHEMA._V_TABLE_STORAGE_STAT WHERE SCHEMA=? AND TABLENAME=?");){
                        dbStat.setString(1, this.getSchemaName());
                        dbStat.setString(2, this.getName());
                        Throwable throwable3 = null;
                        Object var9_15 = null;
                        try (JDBCResultSet dbResult = dbStat.executeQuery();){
                            if (dbResult.next()) {
                                this.fetchStatistics(dbResult);
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error((Object)"Error reading table statistics", (Throwable)e);
                this.hasStatistics = true;
            }
        }
        finally {
            this.hasStatistics = true;
        }
    }

    void fetchStatistics(JDBCResultSet dbResult) throws SQLException {
        this.blockSize = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"BLOCK_SIZE");
        this.allocatedBlocks = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"ALLOCATED_BLOCKS");
        this.allocatedBytes = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"ALLOCATED_BYTES");
        this.allocatedAvg = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"ALLOCATED_AVG");
        this.usedBlocks = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"USED_BLOCKS");
        this.usedBytes = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"USED_BYTES");
        this.usedMin = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"USED_MIN");
        this.usedMax = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"USED_MAX");
        this.usedSpread = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"USED_SPREAD");
        this.hasStatistics = true;
    }

    public synchronized DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.hasStatistics = false;
        return super.refreshObject(monitor);
    }

    public class AdditionalInfo {
        volatile boolean loaded = false;
        private String distributeOn;
        private String organizedOn;

        boolean isLoaded() {
            return this.loaded;
        }

        public void setLoaded(boolean loaded) {
            this.loaded = loaded;
        }

        @Property(viewable=false, editable=true, order=90)
        public String getDistributeOn() {
            return this.distributeOn;
        }

        @Property(viewable=false, editable=true, order=95)
        public String getOrganizedOn() {
            return this.organizedOn;
        }

        public void setOrganizedOn(String organizedOn) {
            this.organizedOn = organizedOn;
        }

        public void setDistributeOn(String distributeOn) {
            this.distributeOn = distributeOn;
        }
    }

    public static class AdditionalInfoValidator
    implements IPropertyCacheValidator<NetezzaGenericTable> {
        public boolean isPropertyCached(NetezzaGenericTable object, Object propertyId) {
            return object.additionalInfo.isLoaded();
        }
    }
}

