/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.netezza.edit;

import com.dbeaver.db.netezza.model.NetezzaDataSourceExt;
import com.dbeaver.db.netezza.model.NetezzaGenericDatabase;
import com.dbeaver.db.netezza.model.NetezzaUser;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class NetezzaUserManager
extends SQLObjectEditor<NetezzaUser, NetezzaGenericDatabase>
implements DBEObjectRenamer<NetezzaUser> {
    public boolean canDeleteObject(NetezzaUser object) {
        return true;
    }

    public boolean canCreateObject(Object container) {
        return true;
    }

    protected String getBaseObjectName() {
        return "NEW_USER";
    }

    protected NetezzaUser createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) throws DBException {
        if (container instanceof NetezzaGenericDatabase) {
            NetezzaGenericDatabase database = (NetezzaGenericDatabase)((Object)container);
            NetezzaUser user = new NetezzaUser("NEW_USER", (NetezzaDataSourceExt)database.getDataSource(), database, null);
            this.setNewObjectName(monitor, (DBSObject)database, (DBSObject)user);
            return user;
        }
        return null;
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) throws DBException {
        NetezzaUser user = (NetezzaUser)command.getObject();
        NetezzaDataSourceExt dataSource = user.getDataSource();
        command.setDisableSessionLogging(true);
        String preparedPassword = SQLUtils.quoteString((DBPDataSource)dataSource, (String)user.getUserPassword());
        String userName = DBObjectNameCaseTransformer.transformName((DBPDataSource)dataSource, (String)user.getName());
        user.setUserName(userName);
        String preparedUserName = DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)userName);
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create user", "CREATE USER " + preparedUserName + " WITH PASSWORD " + preparedPassword));
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        NetezzaUser user = (NetezzaUser)command.getObject();
        Map properties = command.getProperties();
        StringBuilder userOptions = new StringBuilder(64);
        if (properties.containsKey("rowLimit")) {
            userOptions.append(" ROWSETLIMIT ").append(user.getRowLimit());
        }
        if (properties.containsKey("sessionTimeout")) {
            userOptions.append(" SESSIONTIMEOUT ").append(user.getSessionTimeout());
        }
        if (properties.containsKey("queryTimeout")) {
            userOptions.append(" QUERYTIMEOUT ").append(user.getQueryTimeout());
        }
        if (properties.containsKey("defPriority")) {
            userOptions.append(" DEFPRIORITY ").append((Object)user.getDefPriority());
        }
        if (properties.containsKey("maxPriority")) {
            userOptions.append(" MAXPRIORITY ").append((Object)user.getMaxPriority());
        }
        if (userOptions.length() != 0) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Alter user", "ALTER USER " + DBUtils.getQuotedIdentifier((DBSObject)user) + " WITH" + userOptions.toString()));
        }
        super.addObjectModifyActions(monitor, executionContext, actionList, command, options);
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename sequence", "ALTER USER " + DBUtils.getQuotedIdentifier((DBPDataSource)((NetezzaUser)command.getObject()).getDataSource(), (String)command.getOldName()) + " RENAME TO " + DBUtils.getQuotedIdentifier((DBPDataSource)((NetezzaUser)command.getObject()).getDataSource(), (String)command.getNewName())));
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) throws DBException {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop user", "DROP USER " + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject()))));
    }

    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, NetezzaUser> getObjectsCache(NetezzaUser object) {
        return object.getParentObject().getUserCache();
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull NetezzaUser object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }
}

