/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.netezza.edit;

import com.dbeaver.db.netezza.model.NetezzaDataSourceExt;
import com.dbeaver.db.netezza.model.NetezzaGenericSequence;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class NetezzaSequenceManager
extends SQLObjectEditor<GenericSequence, NetezzaDataSourceExt>
implements DBEObjectRenamer<GenericSequence> {
    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull GenericSequence object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }

    public boolean canCreateObject(Object container) {
        return false;
    }

    protected NetezzaGenericSequence createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) throws DBException {
        throw new DBCException("Not Implemented");
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) throws DBException {
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) throws DBException {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop sequence", "DROP SEQUENCE " + ((GenericSequence)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL)));
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        NetezzaGenericSequence sequence = (NetezzaGenericSequence)command.getObject();
        GenericDataSource dataSource = sequence.getDataSource();
        String schemaName = sequence.getSchemaName();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename sequence", "ALTER SEQUENCE " + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)sequence.getDatabaseName()) + "." + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)schemaName) + "." + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getOldName()) + " RENAME TO " + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)schemaName) + "." + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getNewName())));
    }

    protected void addObjectExtraActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.NestedObjectCommand<GenericSequence, SQLObjectEditor.PropertyHandler> command, Map<String, Object> options) {
        if (command.hasProperty((Object)"description")) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment sequence", "COMMENT ON SEQUENCE " + ((GenericSequence)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " IS " + SQLUtils.quoteString((DBSObject)((DBSObject)command.getObject()), (String)CommonUtils.notEmpty((String)((GenericSequence)command.getObject()).getDescription()))));
        }
    }

    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, GenericSequence> getObjectsCache(GenericSequence object) {
        DBSObject parentObject = object.getParentObject();
        if (parentObject instanceof GenericStructContainer) {
            return ((GenericStructContainer)parentObject).getSequenceCache();
        }
        return null;
    }
}

