/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.ui.security;

import com.dbeaver.ee.runtime.core.EnterpriseProjectSecureStorage;
import com.dbeaver.ee.runtime.ui.security.EnterPasswordDialog;
import com.dbeaver.ee.runtime.ui.security.MainWindowProvider;
import com.dbeaver.ee.runtime.ui.security.NewPasswordDialog;
import javax.crypto.SecretKey;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBASecureStorage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.runtime.ui.UIServiceSecurity;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class UIServiceSecurityImpl
implements UIServiceSecurity {
    public String askForPassword(@NotNull String title, String message, @Nullable String defPassword, boolean emptyPasswordAllowed) {
        String[] result = new String[1];
        UIUtils.syncExec(() -> {
            Throwable throwable = null;
            Object var5_6 = null;
            try (MainWindowProvider mainWindowProvider = new MainWindowProvider();){
                stringArray[0] = EnterPasswordDialog.askPassword(mainWindowProvider.getActiveShell(), title, message, defPassword);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
        return result[0];
    }

    public String askForNewPassword(@NotNull String title, @Nullable String defPassword) {
        String[] result = new String[1];
        UIUtils.syncExec(() -> {
            stringArray[0] = NewPasswordDialog.getNewPassword(UIUtils.getActiveWorkbenchShell(), title, null, defPassword);
        });
        return result[0];
    }

    public String askForPasswordChange(@NotNull String title, @NotNull String currentPassword) {
        return null;
    }

    public boolean validatePassword(DBASecureStorage secureStorage, String title, String message, boolean forceEncryption) {
        if (secureStorage instanceof EnterpriseProjectSecureStorage) {
            return this.validateProjectPassword((EnterpriseProjectSecureStorage)secureStorage, title, message, forceEncryption);
        }
        return false;
    }

    private boolean validateProjectPassword(EnterpriseProjectSecureStorage storage, String title, String message, boolean promptUser) {
        DBPProject project = storage.getProject();
        boolean isSecured = CommonUtils.toBoolean((Object)project.getProjectProperty("useProjectPassword"));
        if (!isSecured) {
            if (!promptUser) {
                return true;
            }
            if (!UIUtils.confirmAction((Shell)UIUtils.getActiveWorkbenchShell(), (String)title, (String)"Password view is unavailable if project configuration is not protected by master password.\nDo you want to enable project protection?", (DBPImage)DBIcon.STATUS_WARNING)) {
                return false;
            }
            PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)UIUtils.getActiveWorkbenchShell(), (IAdaptable)project.getEclipseProject(), (String)"com.dbeaver.preferences.projectSecurity", null, null);
            if (dialog.open() == 0) {
                return this.validateProjectPassword(storage, title, message, promptUser);
            }
            return false;
        }
        String password = this.askForPassword(title, message, null, false);
        if (password == null) {
            return false;
        }
        SecretKey key = storage.makeSecretKeyFromPassword(password);
        if (!storage.isValidSecretKey(key)) {
            UIUtils.showMessageBox((Shell)UIUtils.getActiveWorkbenchShell(), (String)title, (String)"Incorrect password", (int)1);
            return false;
        }
        return true;
    }
}

