/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.console;

import com.teradata.jdbc.ResultSetHelper;
import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.jdbc.GenericLogoffController;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc.RowFetchController;
import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.ifsupport.EscapeUtil;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public abstract class ConsoleConnection
extends GenericTeradataConnection
implements ResultSetHelper {
    private boolean autoCommit = true;
    private boolean promptMode = false;

    public ConsoleConnection(String string, String string2, String string3, URLParameters uRLParameters) throws SQLException {
        super(string, string2, string3, uRLParameters);
    }

    protected boolean getPromptMode() {
        return this.promptMode;
    }

    protected void setPromptMode(boolean bl) {
        this.promptMode = bl;
    }

    public void close() throws SQLException {
        if (!this.isClosed()) {
            GenericLogoffController genericLogoffController = new GenericLogoffController(this);
            genericLogoffController.run();
            this.io.close();
        }
    }

    public void commit() throws SQLException {
        this.abortIfClosed();
    }

    public Statement createStatement() throws SQLException {
        this.abortIfClosed();
        return this.constructStatement();
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public boolean getAutoCommit() throws SQLException {
        this.abortIfClosed();
        return this.autoCommit;
    }

    public String getCatalog() throws SQLException {
        this.abortIfClosed();
        return null;
    }

    public int getHoldability() throws SQLException {
        this.abortIfClosed();
        return 1;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public int getTransactionIsolation() throws SQLException {
        this.abortIfClosed();
        return 8;
    }

    public Map getTypeMap() throws SQLException {
        this.abortIfClosed();
        return new HashMap();
    }

    public boolean isReadOnly() throws SQLException {
        this.abortIfClosed();
        return false;
    }

    public String nativeSQL(String string) throws SQLException {
        this.abortIfClosed();
        return EscapeUtil.nativeSQL(string, this.getLocalEscapeFunctions());
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.abortIfClosed();
    }

    public void rollback() throws SQLException {
        this.abortIfClosed();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.abortIfClosed();
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.abortIfClosed();
        this.autoCommit = bl;
    }

    public void setCatalog(String string) throws SQLException {
        this.abortIfClosed();
    }

    public void setHoldability(int n) throws SQLException {
        this.abortIfClosed();
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.abortIfClosed();
    }

    public Savepoint setSavepoint() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.abortIfClosed();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.abortIfClosed();
    }

    public abstract SQLInput constructSQLInput(Object[] var1, int[] var2, int[] var3, String[] var4, Map var5, Class var6);

    public boolean hasResponseNullIndicatorBits() {
        return false;
    }

    public abstract TDResultSet constructResultSet(TeraResultSetMetaData var1, int var2, Statement var3, RowFetchController var4, Log var5) throws SQLException;

    public abstract TeraResultSetMetaData constructResultSetMetaData() throws SQLException;

    protected abstract Statement constructStatement() throws SQLException;

    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Blob createBlob() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Clob createClob() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Properties getClientInfo() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public String getClientInfo(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "getClientInfo(String)");
    }

    public boolean isValid(int n) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }
}

