/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.util.CSEStreamCipher;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.sql.SQLException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

@NotThreadSafe
public final class RsaOaep
extends CSEStreamCipher {
    public static final String JAVA_ALGORITHM_NAME = "RSA";
    public static final String HANA_ALGORITHM_NAME = "RSA-OAEP-2048";
    public static final String TRANSFORMATION_NAME = "RSA/ECB/OAEPPadding";
    private final Cipher _cipher = Cipher.getInstance("RSA/ECB/OAEPPadding");
    private final KeyPairGenerator _keyPairGenerator = KeyPairGenerator.getInstance(this.getJavaAlgorithmName("RSA-OAEP-2048"));

    protected RsaOaep(int keySize) throws NoSuchAlgorithmException, NoSuchPaddingException {
        this._keyPairGenerator.initialize(keySize);
    }

    @Override
    public KeyPair generateKeyPair() {
        return this._keyPairGenerator.generateKeyPair();
    }

    @Override
    public PublicKey generatePublicKeyFromBytes(byte[] publicKeyBytes, String algorithmName) throws SQLException {
        if (publicKeyBytes == null) {
            return null;
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(this.getJavaAlgorithmName(algorithmName));
            return keyFactory.generatePublic(new X509EncodedKeySpec(publicKeyBytes));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.keygeneration.failed", e.getMessage());
        }
    }

    @Override
    public PrivateKey generatePrivateKeyFromBytes(byte[] privateKeyBytes, String algorithmName) throws SQLException {
        if (privateKeyBytes == null) {
            return null;
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(this.getJavaAlgorithmName(algorithmName));
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateKeyBytes));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.keygeneration.failed", e.getMessage());
        }
    }

    @Override
    public byte[] encrypt(Key publicKey, byte[] input) throws SQLException {
        byte[] output;
        try {
            this._cipher.init(1, publicKey);
            output = this._cipher.doFinal(input);
        }
        catch (InvalidKeyException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.crypto.extension.not_installed", e.getMessage());
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.encrypt.failed", e.getMessage());
        }
        return output;
    }

    @Override
    public byte[] decrypt(Key privateKey, byte[] input) throws SQLException {
        byte[] output;
        try {
            this._cipher.init(2, privateKey);
            output = this._cipher.doFinal(input);
        }
        catch (InvalidKeyException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.crypto.extension.not_installed", e.getMessage());
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.decrypt.failed", e.getMessage());
        }
        return output;
    }

    @Override
    public String getJavaAlgorithmName(String algorithmName) {
        if (algorithmName.equalsIgnoreCase(HANA_ALGORITHM_NAME)) {
            return JAVA_ALGORITHM_NAME;
        }
        return "UNKNOWN";
    }

    @Override
    public String getTransformationName(String algorithmName) {
        if (algorithmName.equalsIgnoreCase(HANA_ALGORITHM_NAME)) {
            return TRANSFORMATION_NAME;
        }
        return "UNKNOWN";
    }
}

