/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.Immutable;
import java.util.HashMap;
import java.util.Map;

@Immutable
public final class SiteType
implements Comparable<SiteType> {
    public static final SiteType NONE = new SiteType("NONE", 0, 1);
    public static final SiteType PRIMARY = new SiteType("PRIMARY", 1, 1);
    public static final SiteType SECONDARY = new SiteType("SECONDARY", 2, 2);
    public static final SiteType TERTIARY = new SiteType("TERTIARY", 3, 3);
    private static final Map<Integer, SiteType> SITE_TYPE_MAP = new HashMap<Integer, SiteType>();
    private final String _displayString;
    private final int _value;
    private final int _compareValue;

    static SiteType decode(int value) {
        SiteType siteType = SITE_TYPE_MAP.get(value);
        return siteType != null ? siteType : NONE;
    }

    static SiteType decode(String value) {
        if (value == null || value.isEmpty()) {
            return NONE;
        }
        SiteType siteType = (value = value.trim()).equalsIgnoreCase("PRIMARY") ? PRIMARY : (value.equalsIgnoreCase("SECONDARY") ? SECONDARY : NONE);
        return siteType;
    }

    private SiteType(String displayString, int value, int compareValue) {
        this._displayString = displayString;
        this._value = value;
        this._compareValue = compareValue;
    }

    @Override
    public int compareTo(SiteType other) {
        return this._compareValue - other._compareValue;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SiteType)) {
            return false;
        }
        SiteType other = (SiteType)object;
        return this._compareValue == other._compareValue;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this._compareValue;
        return result;
    }

    public String toString() {
        return this._displayString;
    }

    public int getValue() {
        return this._value;
    }

    static {
        for (SiteType siteType : new SiteType[]{NONE, PRIMARY, SECONDARY, TERTIARY}) {
            SITE_TYPE_MAP.put(siteType._value, siteType);
        }
    }
}

