/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.parser;

import com.vertica.parser.Quote;

public class Token {
    public static final Token SEMICOLON;
    public static final Token PARAMETER_MARKER;
    public static final Token ESCAPE_SEQ_BEGIN;
    public static final Token ESCAPE_SEQ_END;
    public static final Token ESCAPE_SEQ_REPLACEMENT;
    public static final Token ESCAPE_FN;
    public static final Token LIKE_ESCAPE_KEYWORD;
    public static final Token COPY;
    public static final Token FROM;
    public static final Token LOCAL;
    public static final Token STDIN;
    public static final Token RETURNREJECTED;
    public static final Token NO;
    public static final Token COMMIT;
    public static final Token CONVERT;
    public static final Token DATE_CAST;
    public static final Token TIME_CAST;
    public static final Token TIMESTAMP_CAST;
    public static final Token ESCAPE_DATE;
    public static final Token ESCAPE_TIME;
    public static final Token ESCAPE_TIMESTAMP;
    public static final Token REJECTED;
    public static final Token EXCEPTIONS;
    public static final Token LIMIT;
    public static final Token SELECT;
    private String m_tokenText;
    private String m_delim;
    private Quote m_wrappingQuotes;

    public Token(String string, Quote quote, String string2) {
        this.m_wrappingQuotes = quote;
        this.m_delim = string2;
        this.m_tokenText = string;
    }

    public String toString() {
        return this.toString(false);
    }

    private String toString(boolean bl) {
        String string;
        StringBuilder stringBuilder = new StringBuilder(this.m_tokenText.length() + 3 + this.m_delim.length());
        String string2 = this.m_wrappingQuotes.toString();
        switch (this.m_wrappingQuotes.type) {
            case 1: 
            case 16: 
            case 32: {
                string = string2;
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                string = "'";
                break;
            }
            default: {
                string = "";
            }
        }
        stringBuilder.append(string2);
        stringBuilder.append(this.m_tokenText);
        stringBuilder.append(string);
        if (bl) {
            stringBuilder.append(this.m_delim);
        }
        return stringBuilder.toString();
    }

    public String toStringWithDelimiter() {
        return this.toString(true);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Token)) {
            return false;
        }
        Token token = (Token)object;
        return this.toString().equalsIgnoreCase(token.toString());
    }

    public int hashCode() {
        return this.toString().toLowerCase().hashCode();
    }

    static {
        Quote quote = Quote.NO_QUOTES;
        SEMICOLON = new Token(";", quote, "");
        PARAMETER_MARKER = new Token("?", quote, "");
        ESCAPE_SEQ_BEGIN = new Token("{", quote, "");
        ESCAPE_SEQ_END = new Token("}", quote, "");
        ESCAPE_SEQ_REPLACEMENT = new Token(" ", quote, "");
        LIKE_ESCAPE_KEYWORD = new Token("escape", quote, "");
        COPY = new Token("copy", quote, "");
        FROM = new Token("from", quote, "");
        LOCAL = new Token("local", quote, " ");
        STDIN = new Token("stdin", quote, "");
        RETURNREJECTED = new Token("returnrejected", quote, " ");
        NO = new Token("no", quote, "");
        COMMIT = new Token("commit", quote, "");
        CONVERT = new Token("convert", quote, "");
        ESCAPE_FN = new Token("fn", quote, "");
        DATE_CAST = new Token("::date", quote, " ");
        TIME_CAST = new Token("::time", quote, " ");
        TIMESTAMP_CAST = new Token("::timestamp", quote, " ");
        ESCAPE_DATE = new Token("d", quote, "");
        ESCAPE_TIME = new Token("t", quote, "");
        ESCAPE_TIMESTAMP = new Token("ts", quote, "");
        REJECTED = new Token("rejected", quote, "");
        EXCEPTIONS = new Token("exceptions", quote, "");
        LIMIT = new Token("limit", quote, " ");
        SELECT = new Token("select", quote, "");
    }
}

