/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.kv;

import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.jdbc.VerticaJdbc4ConnectionImpl;
import com.vertica.jdbc.kv.KVErrors;
import com.vertica.jdbc.kv.KVLogger;
import com.vertica.jdbc.kv.RoutableConnection;
import com.vertica.jdbc.kv.RoutableConnectionPool;
import com.vertica.jdbc.kv.SQLExceptionChainer;
import com.vertica.jdbc.kv.TableMetadataCache;
import com.vertica.jdbc.kv.VGet;
import com.vertica.jdbc.kv.VGetImpl;
import com.vertica.jdbc.kv.VerticaRoutableConnection;
import com.vertica.jdbc.kv.VerticaRoutableExecutor;
import com.vertica.jdbc.kv.VerticaRoutableExecutorImpl;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicLong;

public class VerticaJdbc4RoutableConnectionImpl
extends VerticaJdbc4ConnectionImpl
implements VerticaRoutableConnection {
    RoutableConnectionPool pool;
    TableMetadataCache metaCache;
    KVLogger log;
    volatile boolean closed;
    AtomicLong epoch;

    public VerticaJdbc4RoutableConnectionImpl(IConnection iConnection, String string) throws SQLException {
        super(iConnection, string);
        this.log = new KVLogger(iConnection.getConnectionLog());
        this.pool = new RoutableConnectionPool(this);
        this.metaCache = new TableMetadataCache(this.pool);
        this.epoch = new AtomicLong(-1L);
    }

    public VGet prepareGet(String string, String string2) throws SQLException {
        this.checkClosed();
        return new VGetImpl(this, string, string2);
    }

    public synchronized void close() throws SQLException {
        if (!this.closed) {
            this.closed = true;
            SQLExceptionChainer sQLExceptionChainer = new SQLExceptionChainer();
            try {
                this.pool.shutdown();
            }
            catch (SQLException sQLException) {
                sQLExceptionChainer.add(sQLException);
            }
            try {
                super.close();
            }
            catch (SQLException sQLException) {
                sQLExceptionChainer.add(sQLException);
            }
            sQLExceptionChainer.throwIfSet();
        }
    }

    public void clearMetadataCache() throws SQLException {
        this.checkClosed();
        this.metaCache.cache.clear();
    }

    public boolean supportsConsistentRead() throws SQLException {
        this.checkClosed();
        boolean bl = false;
        RoutableConnection routableConnection = this.pool.getAnyConnection();
        try {
            Statement statement = routableConnection.conn.createStatement();
            ResultSet resultSet = statement.executeQuery("select get_config_parameter('HistoryRetentionTime')");
            resultSet.next();
            long l = resultSet.getLong(1);
            boolean bl2 = bl = l != 0L;
            if (l < 0L) {
                resultSet.close();
                resultSet = statement.executeQuery("select get_config_parameter('HistoryRetentionEpochs')");
                resultSet.next();
                long l2 = resultSet.getLong(1);
                bl = l2 != 0L;
            }
            resultSet.close();
            statement.close();
            this.pool.returnConnection(routableConnection);
        }
        catch (SQLException sQLException) {
            this.pool.destroyConnection(routableConnection);
            throw sQLException;
        }
        return bl;
    }

    public void beginConsistentRead() throws SQLException {
        this.checkClosed();
        long l = -1L;
        RoutableConnection routableConnection = this.pool.getAnyConnection();
        try {
            try {
                Statement statement = routableConnection.conn.createStatement();
                ResultSet resultSet = statement.executeQuery("select get_current_epoch()");
                resultSet.next();
                l = resultSet.getLong(1) - 1L;
                resultSet.close();
                statement.close();
                this.pool.returnConnection(routableConnection);
            }
            catch (SQLException sQLException) {
                this.pool.destroyConnection(routableConnection);
                throw sQLException;
            }
            Object var7_6 = null;
            if (l != -1L) {
                this.epoch.set(l);
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (l != -1L) {
                this.epoch.set(l);
            }
            throw throwable;
        }
    }

    public void endConsistentRead() throws SQLException {
        this.checkClosed();
        if (this.epoch.get() <= -1L) {
            throw KVErrors.ConsistentReadNotStarted.makeException(new Object[0]);
        }
        this.epoch.set(-1L);
    }

    public VerticaRoutableExecutor createRoutableExecutor(String string, String string2) throws SQLException {
        this.checkClosed();
        return new VerticaRoutableExecutorImpl(this, string, string2);
    }

    private void checkClosed() throws SQLException {
        if (this.closed) {
            throw KVErrors.RoutableConnectionClosed.makeException(new Object[0]);
        }
    }
}

