/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.jdbc3;

import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.jdbc.common.SStatement;
import com.vertica.jdbc.common.SUpdatableForwardResultSet;
import com.vertica.jdbc.jdbc3.S3ResultSetMetaData;
import com.vertica.support.ILogger;
import com.vertica.support.LogUtilities;
import com.vertica.utilities.JDBCVersion;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class S3UpdatableForwardResultSet
extends SUpdatableForwardResultSet {
    public S3UpdatableForwardResultSet(SStatement sStatement, IResultSet iResultSet, ILogger iLogger) throws SQLException {
        super(sStatement, iResultSet, iLogger);
        this.m_jdbcVersion = JDBCVersion.JDBC3;
        try {
            for (int i = this.getMetaData().getColumnCount(); i > 0; --i) {
                this.m_updateValues.add(null);
                this.m_updateStreamValues.add(null);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (null == this.getResultSetMetaData()) {
                this.initializeResultSetColumns();
                this.setResultSetMetadata(new S3ResultSetMetaData(this.getResultSetColumns(), this.m_logger, this.m_warningListener));
            }
            return this.getResultSetMetaData();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }
}

