/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.hybrid;

import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.jdbc3.JDBC3ExceptionConverter;
import com.vertica.support.RebrandingUtilities;
import com.vertica.utilities.JDBCVersion;
import java.lang.reflect.Constructor;

public class HybridUtilities {
    private HybridUtilities() {
    }

    public static void setExeceptionConverter(JDBCVersion jDBCVersion) {
        switch (jDBCVersion) {
            case JDBC3: {
                ExceptionConverter.setInstance(new JDBC3ExceptionConverter());
                break;
            }
            case JDBC4: {
                ExceptionConverter.setInstance(HybridUtilities.createJDBC4ExceptionConverter());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private static ExceptionConverter createJDBC4ExceptionConverter() {
        try {
            Class<?> clazz = Class.forName(HybridUtilities.getJDBC4ExceptionConverterClassName());
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            Object obj = constructor.newInstance(new Object[0]);
            return (ExceptionConverter)obj;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static final String getJDBC4ExceptionConverterClassName() {
        return String.format("com.%s.exceptions.jdbc4.JDBC4ExceptionConverter", RebrandingUtilities.getPackageBranding());
    }
}

