/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc;

import com.vertica.core.VConnection;
import com.vertica.dataengine.VQueryExecutor;
import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.jdbc.VerticaPreparedStatement;
import com.vertica.jdbc.VerticaStatementSharedImpl;
import com.vertica.jdbc.jdbc4.S4Connection;
import com.vertica.jdbc.jdbc4.S4PreparedStatement;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.FeatureNotSupportedException;
import java.sql.BatchUpdateException;
import java.sql.SQLException;

final class VerticaJdbc4PreparedStatementImpl
extends S4PreparedStatement
implements VerticaPreparedStatement {
    protected VerticaJdbc4PreparedStatementImpl(String string, IStatement iStatement, S4Connection s4Connection, int n) throws SQLException {
        super(string, iStatement, s4Connection, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int[] executeBatch() throws SQLException, BatchUpdateException {
        ((VQueryExecutor)this.m_queryExecutor).setInExecuteBatch(true);
        int[] nArray = null;
        try {
            nArray = super.executeBatch();
        }
        finally {
            ((VQueryExecutor)this.m_queryExecutor).setInExecuteBatch(false);
        }
        return nArray;
    }

    public synchronized void clearBatch() throws SQLException {
        if (this.m_statement != null) {
            VConnection vConnection = (VConnection)this.m_statement.getParentConnection();
            FeatureNotSupportedException featureNotSupportedException = VerticaStatementSharedImpl.getInstance().validateClearBatch(vConnection, this.m_queryExecutor);
            if (featureNotSupportedException != null) {
                throw ExceptionConverter.getInstance().toSQLException(featureNotSupportedException, vConnection.getWarningListener());
            }
            super.clearBatch();
        }
    }

    public void cancel() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        super.cancel();
        VerticaStatementSharedImpl.getInstance().cancel(this, this.m_warningListener, this.m_logger);
    }
}

