/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc;

import com.vertica.core.VConnection;
import com.vertica.core.VConnectionPropertyKey;
import com.vertica.core.VDriver;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.jdbc.VerticaDatabaseErrorInfo;
import com.vertica.localization.VMessageKey;
import com.vertica.support.exceptions.ErrorException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;

final class VerticaConnectionSharedImpl {
    private static final VerticaConnectionSharedImpl m_instance = new VerticaConnectionSharedImpl();

    static VerticaConnectionSharedImpl getInstance() {
        return m_instance;
    }

    private VerticaConnectionSharedImpl() {
    }

    public Object getProperty(VConnection vConnection, String string) throws SQLException {
        block43: {
            String string2 = VConnectionPropertyKey.translatePropertyKey(string);
            if (string2 != null) {
                try {
                    if (string2.equalsIgnoreCase("autocommit")) {
                        return vConnection.isAutoCommitEnabled();
                    }
                    if (string2.equalsIgnoreCase("directbatchinsert")) {
                        return vConnection.getDirectBatchInsert();
                    }
                    if (string2.equalsIgnoreCase("connsettings")) {
                        return vConnection.getConnSettings();
                    }
                    if (string2.equalsIgnoreCase("database")) {
                        return vConnection.getDatabaseName();
                    }
                    if (string2.equalsIgnoreCase("host")) {
                        return vConnection.getHost();
                    }
                    if (string2.equalsIgnoreCase("locale")) {
                        return vConnection.getServerLocale();
                    }
                    if (string2.equalsIgnoreCase("loglevel")) {
                        return vConnection.getLogLevel();
                    }
                    if (string2.equalsIgnoreCase("lognamespace")) {
                        return vConnection.getLogNamespace();
                    }
                    if (string2.equalsIgnoreCase("logpath")) {
                        return vConnection.getLogPath();
                    }
                    if (string2.equalsIgnoreCase("logintimeout")) {
                        return vConnection.getLoginTimeout();
                    }
                    if (string2.equalsIgnoreCase("socketfactoryname")) {
                        return vConnection.getSocketFactoryName();
                    }
                    if (string2.equalsIgnoreCase("readonly")) {
                        return vConnection.isReadOnly();
                    }
                    if (string2.equalsIgnoreCase("resultbuffersize")) {
                        return vConnection.getResultBufferSize();
                    }
                    if (string2.equalsIgnoreCase("port")) {
                        return vConnection.getPort();
                    }
                    if (string2.equalsIgnoreCase("sessionlabel")) {
                        return vConnection.getSessionLabel();
                    }
                    if (string2.equalsIgnoreCase("ssl")) {
                        return vConnection.getSSLEnabled();
                    }
                    if (string2.equalsIgnoreCase("searchpath")) {
                        return vConnection.getSearchPath();
                    }
                    if (string2.equalsIgnoreCase("threepartnaming")) {
                        return vConnection.getUseThreePartNaming();
                    }
                    if (string2.equalsIgnoreCase("transactionisolation")) {
                        return vConnection.getTxnIsolation();
                    }
                    if (string2.equalsIgnoreCase("user")) {
                        return vConnection.getUser();
                    }
                    if (string2.equalsIgnoreCase("addtztotimestampparameters")) {
                        return vConnection.getAddTzToTimestampParameters();
                    }
                    if (string2.equalsIgnoreCase("connectionloadbalance")) {
                        return vConnection.getConnectionLoadBalance();
                    }
                    if (string2.equalsIgnoreCase("backupservernode")) {
                        return vConnection.getBackupServerNode();
                    }
                    if (string2.equalsIgnoreCase("jaasconfigname")) {
                        return vConnection.getJAASConfigName();
                    }
                    if (string2.equalsIgnoreCase("kerberosservicename")) {
                        return vConnection.getKerberosServiceName();
                    }
                    if (string2.equalsIgnoreCase("kerberoshostname")) {
                        return vConnection.getKerberosHostName();
                    }
                    if (string2.equalsIgnoreCase("streamingbatchinsert")) {
                        return vConnection.getStreamingBatchInsert();
                    }
                    if (string2.equalsIgnoreCase("disablecopylocal")) {
                        return vConnection.getDisableCopyLocal();
                    }
                    if (string2.equalsIgnoreCase("networkbuffersize")) {
                        return vConnection.getNetworkBufferSize();
                    }
                    if (string2.equalsIgnoreCase("enableroutablequeries")) {
                        return vConnection.getEnableRoutableQueries();
                    }
                    if (string2.equalsIgnoreCase("failonmultinodeplans")) {
                        return vConnection.getFailOnMultiNodePlans();
                    }
                    if (string2.equalsIgnoreCase("maxpooledconnectionuses")) {
                        return vConnection.getMaxPooledConnectionUses();
                    }
                    if (string2.equalsIgnoreCase("maxpooledconnections")) {
                        return vConnection.getMaxPooledConnections();
                    }
                    if (string2.equalsIgnoreCase("maxpooledconnectionspernode")) {
                        return vConnection.getMaxPooledConnectionsPerNode();
                    }
                    if (string2.equalsIgnoreCase("metadatacachelifetime")) {
                        return vConnection.getMetadataCacheLifetime();
                    }
                    if (string2.equalsIgnoreCase("nodedownwaittime")) {
                        return vConnection.getNodeDownWaitTime();
                    }
                    if (string2.equalsIgnoreCase("preferredaddressfamily")) {
                        return vConnection.getPreferredAddressFamily().toString();
                    }
                    if (string2.equalsIgnoreCase("mars")) {
                        return vConnection.getMarsEnabled();
                    }
                    break block43;
                }
                catch (Exception exception) {
                    assert (false);
                    return null;
                }
            }
            if (string != null && string.equalsIgnoreCase("inlrs")) {
                return vConnection.inLRS();
            }
        }
        return null;
    }

    public void setProperty(VConnection vConnection, String string, Object object) throws SQLException {
        block22: {
            String[] stringArray = VConnectionPropertyKey.translateSetting(string, object);
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            if (string2 == null) {
                throw ExceptionConverter.getInstance().toSQLException(VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.ERROR_INVALID_PROPERTY.toString(), string), vConnection.getWarningListener());
            }
            if (string3 == null) {
                HashSet<String> hashSet = VConnectionPropertyKey.getLegalValueSet(string2);
                if (hashSet != null) {
                    Object[] objectArray = new String[hashSet.size()];
                    objectArray = hashSet.toArray(objectArray);
                    Arrays.sort(objectArray);
                    throw ExceptionConverter.getInstance().toSQLException(VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.ERROR_ILLEGAL_PROPERTY_VALUE_SET.toString(), new String[]{object == null ? "null" : object.toString(), string, Arrays.toString(objectArray)}), vConnection.getWarningListener());
                }
                throw ExceptionConverter.getInstance().toSQLException(VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.ERROR_ILLEGAL_PROPERTY_VALUE.toString(), new String[]{object == null ? "null" : object.toString(), string}), vConnection.getWarningListener());
            }
            try {
                if (string2.equalsIgnoreCase("directbatchinsert")) {
                    vConnection.setDirectBatchInsert(Boolean.parseBoolean(string3));
                    break block22;
                }
                if (string2.equalsIgnoreCase("locale")) {
                    vConnection.setServerLocale(string3, true);
                    break block22;
                }
                if (string2.equalsIgnoreCase("loglevel")) {
                    vConnection.setLogLevel(string3);
                    break block22;
                }
                if (string2.equalsIgnoreCase("lognamespace")) {
                    vConnection.setLogPackage(string3);
                    break block22;
                }
                if (string2.equalsIgnoreCase("resultbuffersize")) {
                    vConnection.setResultBufferSize(Integer.parseInt(string3));
                    break block22;
                }
                if (string2.equalsIgnoreCase("searchpath")) {
                    vConnection.setSearchPath(string3, true);
                    break block22;
                }
                if (string2.equalsIgnoreCase("threepartnaming")) {
                    vConnection.setUseThreePartNaming(Boolean.parseBoolean(string3));
                    break block22;
                }
                if (string2.equalsIgnoreCase("mars")) {
                    vConnection.setServerMarsEnabled(Boolean.parseBoolean(string3));
                    break block22;
                }
                if (string2.equalsIgnoreCase("addtztotimestampparameters")) {
                    vConnection.setAddTzToTimestampParameters(Boolean.parseBoolean(string3));
                    break block22;
                }
                if (string2.equalsIgnoreCase("failonmultinodeplans")) {
                    vConnection.setFailOnMultinodePlans(Boolean.parseBoolean(string3));
                    break block22;
                }
                if (string2.equalsIgnoreCase("maxpooledconnectionuses")) {
                    vConnection.setMaxPooledConnectionUses(Integer.parseInt(string3));
                    break block22;
                }
                if (string2.equalsIgnoreCase("maxpooledconnections")) {
                    vConnection.setMaxPooledConnections(Integer.parseInt(string3));
                    break block22;
                }
                if (string2.equalsIgnoreCase("maxpooledconnectionspernode")) {
                    vConnection.setMaxPooledConnectionsPerNode(Integer.parseInt(string3));
                    break block22;
                }
                if (string2.equalsIgnoreCase("metadatacachelifetime")) {
                    vConnection.setMetadataCacheLifetime(Integer.parseInt(string3));
                    break block22;
                }
                if (string2.equalsIgnoreCase("nodedownwaittime")) {
                    vConnection.setNodeDownWaitTime(Integer.parseInt(string3));
                    break block22;
                }
                if (string2.equalsIgnoreCase("streamingbatchinsert")) {
                    vConnection.setStreamingBatchInsert(Boolean.parseBoolean(string3));
                    break block22;
                }
                if (string2.equalsIgnoreCase("disablecopylocal")) {
                    vConnection.setDisableCopyLocal(Boolean.parseBoolean(string3));
                    break block22;
                }
                throw ExceptionConverter.getInstance().toSQLException(VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.ERROR_PROPERTY_NOT_SETTABLE.toString(), string), vConnection.getWarningListener());
            }
            catch (ErrorException errorException) {
                throw ExceptionConverter.getInstance().toSQLException(errorException, vConnection.getWarningListener());
            }
        }
    }

    public VerticaDatabaseErrorInfo getLastDatabaseError(VConnection vConnection) {
        return vConnection.getLastServerErrorData();
    }
}

