/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.data.preferences;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Spinner;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ValueFormatSelector;
import org.jkiss.dbeaver.ui.editors.data.internal.DataEditorsMessages;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageResultSetPresentationPlainText
extends TargetPrefPage {
    private static final Log log = Log.getLog(PrefPageResultSetPresentationPlainText.class);
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.resultset.plain.text";
    private Spinner textTabSize;
    private Spinner textMaxColumnSize;
    private ValueFormatSelector textValueFormat;
    private Button showNulls;
    private Button textDelimiterLeading;
    private Button textDelimiterTrailing;
    private Button textDelimiterTop;
    private Button textDelimiterBottom;
    private Button textExtraSpaces;
    private Button textLineNumber;

    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("resultset.text.tab.size") || store.contains("resultset.text.max.column.size") || store.contains("resultset.text.value.format") || store.contains("resultset.text.show.nulls") || store.contains("resultset.text.delimiter.leading") || store.contains("resultset.text.delimiter.trailing") || store.contains("resultset.text.delimiter.top") || store.contains("resultset.text.delimiter.bottom") || store.contains("resultset.text.extra.spaces") || store.contains("resultset.text.line.number");
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)2, (int)5);
        Group uiGroup = UIUtils.createControlGroup((Composite)composite, (String)DataEditorsMessages.pref_page_database_resultsets_group_plain_text, (int)2, (int)2, (int)0);
        this.textTabSize = UIUtils.createLabelSpinner((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_tab_width, (int)0, (int)1, (int)100);
        this.textMaxColumnSize = UIUtils.createLabelSpinner((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_maximum_column_length, (int)0, (int)10, (int)Integer.MAX_VALUE);
        this.textValueFormat = new ValueFormatSelector((Composite)uiGroup);
        this.showNulls = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_text_show_nulls, null, (boolean)false, (int)2);
        this.textLineNumber = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_text_show_line_numbers, (String)DataEditorsMessages.pref_page_database_resultsets_label_text_show_line_numbers_tip, (boolean)false, (int)2);
        this.textDelimiterLeading = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_text_delimiter_leading, null, (boolean)false, (int)2);
        this.textDelimiterTrailing = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_text_delimiter_trailing, null, (boolean)false, (int)2);
        this.textDelimiterTop = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_text_delimiter_top, null, (boolean)false, (int)2);
        this.textDelimiterBottom = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_text_delimiter_bottom, null, (boolean)false, (int)2);
        this.textExtraSpaces = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_text_extra_spaces, null, (boolean)false, (int)2);
        return composite;
    }

    protected void loadPreferences(DBPPreferenceStore store) {
        try {
            this.textTabSize.setSelection(store.getInt("resultset.text.tab.size"));
            this.textMaxColumnSize.setSelection(store.getInt("resultset.text.max.column.size"));
            this.textValueFormat.select(DBDDisplayFormat.safeValueOf((String)store.getString("resultset.text.value.format")));
            this.showNulls.setSelection(store.getBoolean("resultset.text.show.nulls"));
            this.textDelimiterLeading.setSelection(store.getBoolean("resultset.text.delimiter.leading"));
            this.textDelimiterTrailing.setSelection(store.getBoolean("resultset.text.delimiter.trailing"));
            this.textDelimiterTop.setSelection(store.getBoolean("resultset.text.delimiter.top"));
            this.textLineNumber.setSelection(store.getBoolean("resultset.text.line.number"));
            this.textDelimiterBottom.setSelection(store.getBoolean("resultset.text.delimiter.bottom"));
            this.textExtraSpaces.setSelection(store.getBoolean("resultset.text.extra.spaces"));
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    protected void savePreferences(DBPPreferenceStore store) {
        try {
            store.setValue("resultset.text.tab.size", this.textTabSize.getSelection());
            store.setValue("resultset.text.max.column.size", this.textMaxColumnSize.getSelection());
            store.setValue("resultset.text.value.format", this.textValueFormat.getSelection().name());
            store.setValue("resultset.text.show.nulls", this.showNulls.getSelection());
            store.setValue("resultset.text.delimiter.leading", this.textDelimiterLeading.getSelection());
            store.setValue("resultset.text.delimiter.trailing", this.textDelimiterTrailing.getSelection());
            store.setValue("resultset.text.delimiter.top", this.textDelimiterTop.getSelection());
            store.setValue("resultset.text.line.number", this.textLineNumber.getSelection());
            store.setValue("resultset.text.delimiter.bottom", this.textDelimiterBottom.getSelection());
            store.setValue("resultset.text.extra.spaces", this.textExtraSpaces.getSelection());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("resultset.text.tab.size");
        store.setToDefault("resultset.text.max.column.size");
        store.setToDefault("resultset.text.value.format");
        store.setToDefault("resultset.text.show.nulls");
        store.setToDefault("resultset.text.delimiter.leading");
        store.setToDefault("resultset.text.delimiter.trailing");
        store.setToDefault("resultset.text.delimiter.top");
        store.setToDefault("resultset.text.delimiter.bottom");
        store.setToDefault("resultset.text.extra.spaces");
    }

    protected String getPropertyPageID() {
        return PAGE_ID;
    }
}

