/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.panel.grouping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainer;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.GroupingDataContainer;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.GroupingResultsDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.view.EmptyPresentation;
import org.jkiss.utils.CommonUtils;

public class GroupingResultsContainer
implements IResultSetContainer {
    private static final Log log = Log.getLog(GroupingResultsContainer.class);
    public static final String FUNCTION_COUNT = "COUNT";
    public static final String DEFAULT_FUNCTION = "COUNT(*)";
    private final IResultSetPresentation presentation;
    private GroupingDataContainer dataContainer;
    private ResultSetViewer groupingViewer;
    private List<String> groupAttributes = new ArrayList<String>();
    private List<String> groupFunctions = new ArrayList<String>();

    public GroupingResultsContainer(Composite parent, IResultSetPresentation presentation) {
        this.presentation = presentation;
        this.dataContainer = new GroupingDataContainer(presentation.getController());
        this.groupingViewer = new ResultSetViewer(parent, presentation.getController().getSite(), this);
        this.initDefaultSettings();
    }

    private void initDefaultSettings() {
        this.groupAttributes.clear();
        this.groupFunctions.clear();
        this.addGroupingFunctions(Collections.singletonList(DEFAULT_FUNCTION));
    }

    public IResultSetPresentation getOwnerPresentation() {
        return this.presentation;
    }

    public List<String> getGroupAttributes() {
        return this.groupAttributes;
    }

    public List<String> getGroupFunctions() {
        return this.groupFunctions;
    }

    @Override
    @Nullable
    public DBPProject getProject() {
        DBSDataContainer dataContainer = this.getDataContainer();
        return dataContainer == null || dataContainer.getDataSource() == null ? null : dataContainer.getDataSource().getContainer().getProject();
    }

    public DBCExecutionContext getExecutionContext() {
        return this.presentation.getController().getExecutionContext();
    }

    @Override
    @NotNull
    public IResultSetController getResultSetController() {
        return this.groupingViewer;
    }

    @Override
    public DBSDataContainer getDataContainer() {
        return this.dataContainer;
    }

    @Override
    public boolean isReadyToRun() {
        return true;
    }

    @Override
    public void openNewContainer(DBRProgressMonitor monitor, @NotNull DBSDataContainer dataContainer, @NotNull DBDDataFilter newFilter) {
    }

    @Override
    public IResultSetDecorator createResultSetDecorator() {
        return new GroupingResultsDecorator(this);
    }

    void clearGroupingAttributes() {
        this.groupAttributes.clear();
    }

    void addGroupingAttributes(List<String> attributes) {
        for (String attrName : attributes) {
            if (this.groupAttributes.contains(attrName = this.cleanupObjectName(attrName))) continue;
            this.groupAttributes.add(attrName);
        }
    }

    boolean removeGroupingAttribute(List<String> attributes) {
        boolean changed = false;
        for (String attrName : attributes) {
            if (!this.groupAttributes.contains(attrName = this.cleanupObjectName(attrName))) continue;
            this.groupAttributes.remove(attrName);
            changed = true;
        }
        if (changed) {
            this.resetDataFilters();
        }
        return changed;
    }

    private String cleanupObjectName(String attrName) {
        DBPDataSource dataSource = this.getDataContainer().getDataSource();
        attrName = DBUtils.isQuotedIdentifier((DBPDataSource)dataSource, (String)attrName) ? DBUtils.getUnQuotedIdentifier((DBPDataSource)dataSource, (String)attrName) : DBObjectNameCaseTransformer.transformName((DBPDataSource)dataSource, (String)attrName);
        return attrName;
    }

    public void addGroupingFunctions(List<String> functions) {
        for (String func : functions) {
            func = DBUtils.getUnQuotedIdentifier((DBPDataSource)this.getDataContainer().getDataSource(), (String)func);
            if (this.groupFunctions.contains(func)) continue;
            this.groupFunctions.add(func);
        }
    }

    public boolean removeGroupingFunction(List<String> attributes) {
        boolean changed = false;
        for (String func : attributes) {
            func = DBUtils.getUnQuotedIdentifier((DBPDataSource)this.getDataContainer().getDataSource(), (String)func);
            if (!this.groupFunctions.contains(func)) continue;
            this.groupFunctions.remove(func);
            changed = true;
        }
        return changed;
    }

    public void clearGrouping() {
        this.initDefaultSettings();
        this.groupingViewer.clearData(true);
        this.groupingViewer.clearDataFilter(false);
        this.groupingViewer.resetHistory();
        this.dataContainer.setGroupingQuery(null);
        this.dataContainer.setGroupingAttributes(null);
        if (!(this.groupingViewer.getActivePresentation() instanceof EmptyPresentation)) {
            this.groupingViewer.showEmptyPresentation();
        }
    }

    public void rebuildGrouping() throws DBException {
        if (this.groupAttributes.isEmpty() || this.groupFunctions.isEmpty()) {
            this.groupingViewer.showEmptyPresentation();
            return;
        }
        DBCStatistics statistics = this.presentation.getController().getModel().getStatistics();
        if (statistics == null) {
            throw new DBException("No main query - can't perform grouping");
        }
        boolean isCustomQuery = !(this.presentation.getController().getDataContainer() instanceof DBSEntity);
        DBPDataSource dataSource = this.dataContainer.getDataSource();
        if (dataSource == null) {
            throw new DBException("No active datasource");
        }
        SQLDialect dialect = SQLUtils.getDialectFromDataSource((DBPDataSource)dataSource);
        SQLSyntaxManager syntaxManager = new SQLSyntaxManager();
        syntaxManager.init(dialect, this.presentation.getController().getPreferenceStore());
        String queryText = statistics.getQueryText();
        if (queryText == null || queryText.isEmpty()) {
            DBSDataContainer dataContainer = this.presentation.getController().getDataContainer();
            if (dataContainer != null) {
                queryText = dataContainer.getName();
            } else {
                throw new DBException("Empty data container");
            }
        }
        String[] stringArray = syntaxManager.getStatementDelimiters();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String delimiter = stringArray[n2];
            while (queryText.endsWith(delimiter)) {
                queryText = queryText.substring(0, queryText.length() - delimiter.length());
            }
            ++n2;
        }
        boolean useAliasForColumns = this.dataContainer.getDataSource().getSQLDialect().supportsAliasInConditions();
        StringBuilder sql = new StringBuilder();
        String[] funcAliases = new String[this.groupFunctions.size()];
        int i = 0;
        while (i < this.groupFunctions.size()) {
            funcAliases[i] = useAliasForColumns ? this.makeGroupFunctionAlias(i) : this.groupFunctions.get(i);
            ++i;
        }
        if (isCustomQuery && dialect.supportsSubqueries()) {
            sql.append("SELECT ");
            i = 0;
            while (i < this.groupAttributes.size()) {
                if (i > 0) {
                    sql.append(", ");
                }
                sql.append(this.quotedGroupingString(dataSource, this.groupAttributes.get(i)));
                ++i;
            }
            i = 0;
            while (i < this.groupFunctions.size()) {
                String func = this.groupFunctions.get(i);
                sql.append(", ").append(func);
                if (useAliasForColumns) {
                    sql.append(" as ").append(funcAliases[i]);
                }
                ++i;
            }
            sql.append(" FROM (\n");
            sql.append(queryText);
            sql.append("\n) src");
        } else {
            try {
                Statement statement = SQLSemanticProcessor.parseQuery((SQLDialect)dataSource.getSQLDialect(), (String)queryText);
                if (statement instanceof Select && ((Select)statement).getSelectBody() instanceof PlainSelect) {
                    PlainSelect select = (PlainSelect)((Select)statement).getSelectBody();
                    select.setOrderByElements(null);
                    ArrayList<SelectExpressionItem> selectItems = new ArrayList<SelectExpressionItem>();
                    select.setSelectItems(selectItems);
                    for (String groupAttribute : this.groupAttributes) {
                        selectItems.add(new SelectExpressionItem((Expression)new Column(this.quotedGroupingString(dataSource, groupAttribute))));
                    }
                    int i2 = 0;
                    while (i2 < this.groupFunctions.size()) {
                        String func = this.groupFunctions.get(i2);
                        Expression expression = SQLSemanticProcessor.parseExpression((String)func);
                        SelectExpressionItem sei = new SelectExpressionItem(expression);
                        if (useAliasForColumns) {
                            sei.setAlias(new Alias(funcAliases[i2]));
                        }
                        selectItems.add(sei);
                        ++i2;
                    }
                }
                queryText = statement.toString();
            }
            catch (Throwable e) {
                log.debug((Object)"SQL parse error", e);
            }
            sql.append(queryText);
        }
        sql.append("\nGROUP BY ");
        i = 0;
        while (i < this.groupAttributes.size()) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(this.quotedGroupingString(dataSource, this.groupAttributes.get(i)));
            ++i;
        }
        boolean isDefaultGrouping = this.groupFunctions.size() == 1 && this.groupFunctions.get(0).equals(DEFAULT_FUNCTION);
        boolean isShowDuplicatesOnly = dataSource.getContainer().getPreferenceStore().getBoolean("resultset.grouping.showDuplicatesOnly");
        if (isDefaultGrouping && isShowDuplicatesOnly) {
            sql.append("\nHAVING ").append(funcAliases[0]).append(" > 1");
        }
        this.dataContainer.setGroupingQuery(sql.toString());
        this.dataContainer.setGroupingAttributes((String[])this.groupAttributes.toArray(String[]::new));
        DBDDataFilter dataFilter = this.presentation.getController().getModel().isMetadataChanged() ? new DBDDataFilter() : new DBDDataFilter(this.groupingViewer.getModel().getDataFilter());
        String defaultSorting = dataSource.getContainer().getPreferenceStore().getString("resultset.grouping.defaultSorting");
        if (!CommonUtils.isEmpty((String)defaultSorting) && isDefaultGrouping) {
            dataFilter.setOrder(String.valueOf(funcAliases[funcAliases.length - 1]) + " " + defaultSorting);
        }
        this.groupingViewer.setDataFilter(dataFilter, true);
    }

    private String makeGroupFunctionAlias(int funcIndex) {
        String function = this.groupFunctions.get(funcIndex);
        StringBuilder alias = new StringBuilder();
        int i = 0;
        while (i < function.length()) {
            char c = function.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') {
                alias.append(c);
            }
            ++i;
        }
        if (alias.length() > 0) {
            alias.append('_');
            return alias.toString().toLowerCase(Locale.ENGLISH);
        }
        return "i_" + funcIndex;
    }

    void setGrouping(List<String> attributes, List<String> functions) {
        this.groupAttributes.clear();
        this.addGroupingAttributes(attributes);
        this.groupFunctions.clear();
        this.addGroupingFunctions(functions);
        this.resetDataFilters();
    }

    private void resetDataFilters() {
        this.groupingViewer.getModel().createDataFilter();
    }

    private String quotedGroupingString(DBPDataSource dataSource, String string) {
        try {
            Expression expression = SQLSemanticProcessor.parseExpression((String)string);
            if (!(expression instanceof Column)) {
                return string;
            }
        }
        catch (DBException e) {
            log.debug((Object)("Can't parse expression " + string), (Throwable)e);
        }
        return DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)string);
    }
}

