/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDictionary;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.DataFilterRegistry;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.utils.CommonUtils;

public class ResultSetUtils {
    private static final Log log = Log.getLog(ResultSetUtils.class);
    private static volatile IDialogSettings viewerSettings;

    @NotNull
    public static IDialogSettings getViewerSettings(String section) {
        if (viewerSettings == null) {
            viewerSettings = UIUtils.getDialogSettings((String)ResultSetViewer.class.getSimpleName());
        }
        return UIUtils.getSettingsSection((IDialogSettings)viewerSettings, (String)section);
    }

    @Nullable
    public static Object getAttributeValueFromClipboard(DBDAttributeBinding attribute) throws DBCException {
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        try {
            Object object;
            block13: {
                Throwable throwable = null;
                Object var3_4 = null;
                DBCSession session = DBUtils.openUtilSession((DBRProgressMonitor)new VoidProgressMonitor(), (DBSObject)attribute, (String)"Copy from clipboard");
                try {
                    String strValue = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
                    object = attribute.getValueHandler().getValueFromObject(session, (DBSTypedObject)attribute.getAttribute(), (Object)strValue, true, false);
                    if (session == null) break block13;
                }
                catch (Throwable throwable2) {
                    try {
                        if (session != null) {
                            session.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                session.close();
            }
            return object;
        }
        finally {
            clipboard.dispose();
        }
    }

    public static void copyToClipboard(String string) {
        if (string != null && string.length() > 0) {
            Clipboard clipboard = new Clipboard(Display.getCurrent());
            try {
                TextTransfer textTransfer = TextTransfer.getInstance();
                clipboard.setContents(new Object[]{string}, new Transfer[]{textTransfer});
            }
            finally {
                clipboard.dispose();
            }
        }
    }

    public static void copyToClipboard(Map<Transfer, Object> formats) {
        if (!formats.isEmpty()) {
            Clipboard clipboard = new Clipboard(Display.getCurrent());
            try {
                Transfer[] transfers = new Transfer[formats.size()];
                Object[] values = new Object[formats.size()];
                int index = 0;
                for (Map.Entry<Transfer, Object> fmtEntry : formats.entrySet()) {
                    transfers[index] = fmtEntry.getKey();
                    values[index] = fmtEntry.getValue();
                    ++index;
                }
                clipboard.setContents(values, transfers);
            }
            finally {
                clipboard.dispose();
            }
        }
    }

    public static OrderingMode getOrderingMode(IResultSetController controller) {
        return (OrderingMode)CommonUtils.valueOf(OrderingMode.class, (String)controller.getPreferenceStore().getString("resultset.order.mode"), (Enum)OrderingMode.SMART);
    }

    public static RGB makeGradientValue(RGB c1, RGB c2, double minValue, double maxValue, double value) {
        if (value <= minValue) {
            return c1;
        }
        if (value >= maxValue) {
            return c2;
        }
        double range = maxValue - minValue;
        double p = (value - minValue) / range;
        return new RGB((int)((double)c2.red * p + (double)c1.red * (1.0 - p)), (int)((double)c2.green * p + (double)c1.green * (1.0 - p)), (int)((double)c2.blue * p + (double)c1.blue * (1.0 - p)));
    }

    public static DBSEntityReferrer getEnumerableConstraint(DBDAttributeBinding binding) {
        try {
            DBSDictionary dictionary;
            List refs;
            DBSEntityReferrer constraint;
            DBSEntity associatedEntity;
            DBSEntityAttribute entityAttribute = binding.getEntityAttribute();
            if (entityAttribute != null && (associatedEntity = ResultSetUtils.getAssociatedEntity((DBSEntityConstraint)(constraint = (refs = DBUtils.getAttributeReferrers((DBRProgressMonitor)new VoidProgressMonitor(), (DBSEntityAttribute)entityAttribute, (boolean)true)).isEmpty() ? null : (DBSEntityReferrer)refs.get(0)))) instanceof DBSDictionary && (dictionary = (DBSDictionary)associatedEntity).supportsDictionaryEnumeration()) {
                return constraint;
            }
        }
        catch (Throwable e) {
            log.error((Object)e);
        }
        return null;
    }

    public static DBSEntity getAssociatedEntity(DBSEntityConstraint constraint) {
        DBSEntity[] associatedEntity = new DBSEntity[1];
        if (constraint instanceof DBSEntityAssociation) {
            associatedEntity[0] = ((DBSEntityAssociation)constraint).getAssociatedEntity();
        }
        return associatedEntity[0];
    }

    static String formatRowCount(long rows) {
        return rows < 0L ? "0" : String.valueOf(rows);
    }

    public static DBDDataFilter restoreDataFilter(DBSDataContainer dataContainer, @NotNull DBRProgressMonitor monitor) {
        DataFilterRegistry.SavedDataFilter savedConfig = DataFilterRegistry.getInstance().getSavedConfig(dataContainer);
        if (savedConfig != null) {
            DBDDataFilter dataFilter = new DBDDataFilter();
            try {
                savedConfig.restoreDataFilter(monitor, dataContainer, dataFilter);
            }
            catch (DBException e) {
                log.warn((Object)("Can't restore table data filters for " + dataContainer.getName()), (Throwable)e);
            }
            if (dataFilter.hasFilters()) {
                return dataFilter;
            }
        }
        return null;
    }

    public static enum OrderingMode {
        SMART(ResultSetMessages.pref_page_database_resultsets_label_order_mode_smart),
        CLIENT_SIDE(ResultSetMessages.pref_page_database_resultsets_label_order_mode_always_client),
        SERVER_SIDE(ResultSetMessages.pref_page_database_resultsets_label_order_mode_always_server);

        private final String text;

        private OrderingMode(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }
}

