/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.ColumnName;
import org.relique.jdbc.csv.CsvResources;
import org.relique.jdbc.csv.CsvStatement;
import org.relique.jdbc.csv.Expression;
import org.relique.jdbc.csv.ParsedExpression;
import org.relique.jdbc.csv.ParsedStatement;
import org.relique.jdbc.csv.SqlParser;
import org.relique.jdbc.csv.SubQueryEqualsRowMatcher;
import org.relique.jdbc.csv.SubQueryRowMatcher;

class SubQueryExpression
extends Expression {
    private ParsedStatement parsedStatement;

    public SubQueryExpression(ParsedStatement parsedStatement) {
        this.parsedStatement = parsedStatement;
    }

    @Override
    public Object eval(Map<String, Object> env) throws SQLException {
        SubQueryEqualsRowMatcher rowMatcher = new SubQueryEqualsRowMatcher();
        this.evalList(env, rowMatcher);
        ArrayList<Object> rowMatcherValues = rowMatcher.getValues();
        int nRows = rowMatcherValues.size();
        if (nRows == 0) {
            return null;
        }
        if (nRows > 1) {
            throw new SQLException(CsvResources.getString("subqueryOneRow"));
        }
        return rowMatcherValues.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evalList(Map<String, Object> env, SubQueryRowMatcher rowMatcher) throws SQLException {
        boolean matches = false;
        CsvStatement statement = null;
        ResultSet resultSet = null;
        try {
            SqlParser sqlParser = new SqlParser();
            for (ParsedExpression parsedExpr : this.parsedStatement.queryEntries) {
                parsedExpr.resetAggregateFunctions();
            }
            sqlParser.setParsedStatement(this.parsedStatement);
            ColumnName expr = new ColumnName("@STATEMENT");
            statement = (CsvStatement)((Expression)expr).eval(env);
            resultSet = statement.executeParsedQuery(sqlParser, env);
            if (resultSet.getMetaData().getColumnCount() != 1) {
                throw new SQLException(CsvResources.getString("subqueryOneColumn"));
            }
            while (!matches && resultSet.next()) {
                Object o = resultSet.getObject(1);
                matches = rowMatcher.matches(o);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        return matches;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(this.parsedStatement.toString());
        sb.append(")");
        return sb.toString();
    }

    @Override
    public List<String> usedColumns(Set<String> availableColumns) {
        LinkedList<String> retval = new LinkedList<String>();
        List<String> usedColumns = this.parsedStatement.usedColumns(availableColumns);
        for (String column : usedColumns) {
            if (!availableColumns.contains(column)) continue;
            retval.add(column);
        }
        return retval;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        return new LinkedList<AggregateFunction>();
    }
}

