/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.Expression;

class SQLCoalesceFunction
extends Expression {
    List<Expression> expressions;

    public SQLCoalesceFunction(List<Expression> expressions) {
        this.expressions = expressions;
    }

    @Override
    public Object eval(Map<String, Object> env) throws SQLException {
        Object retval = null;
        Iterator<Expression> it = this.expressions.iterator();
        while (retval == null && it.hasNext()) {
            Expression expr = it.next();
            retval = expr.eval(env);
        }
        return retval;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("COALESCE(");
        String delimiter = "";
        Iterator<Expression> it = this.expressions.iterator();
        while (it.hasNext()) {
            sb.append(delimiter);
            sb.append(it.next().toString());
            delimiter = ",";
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public List<String> usedColumns(Set<String> availableColumns) {
        LinkedList<String> result = new LinkedList<String>();
        Iterator<Expression> it = this.expressions.iterator();
        while (it.hasNext()) {
            result.addAll(it.next().usedColumns(availableColumns));
        }
        return result;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> result = new LinkedList<AggregateFunction>();
        Iterator<Expression> it = this.expressions.iterator();
        while (it.hasNext()) {
            result.addAll(it.next().aggregateFunctions());
        }
        return result;
    }
}

