/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.Expression;
import org.relique.jdbc.csv.InExpressionSubQueryRowMatcher;
import org.relique.jdbc.csv.LogicalExpression;
import org.relique.jdbc.csv.RelopExpression;
import org.relique.jdbc.csv.SubQueryExpression;

class InExpression
extends LogicalExpression {
    Expression obj;
    List<Expression> inList = null;
    SubQueryExpression subQuery = null;

    public InExpression(Expression obj, List<Expression> inList) {
        this.obj = obj;
        this.inList = inList;
    }

    public InExpression(Expression obj, SubQueryExpression subQuery) {
        this.obj = obj;
        this.subQuery = subQuery;
    }

    @Override
    public Boolean isTrue(Map<String, Object> env) throws SQLException {
        Comparable objValue = (Comparable)this.obj.eval(env);
        if (objValue == null) {
            return null;
        }
        if (this.inList != null) {
            for (Expression expr : this.inList) {
                Comparable exprValue = (Comparable)expr.eval(env);
                Integer compared = RelopExpression.compare(objValue, exprValue, env);
                if (compared == null || compared != 0) continue;
                return Boolean.TRUE;
            }
        } else {
            boolean matches = this.subQuery.evalList(env, new InExpressionSubQueryRowMatcher(env, objValue));
            return matches;
        }
        return Boolean.FALSE;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IN ");
        sb.append(this.obj.toString());
        if (this.inList != null) {
            sb.append(" (");
            String delimiter = "";
            for (Expression expr : this.inList) {
                sb.append(delimiter);
                sb.append(expr.toString());
                delimiter = ", ";
            }
            sb.append(")");
        } else {
            sb.append(this.subQuery.toString());
        }
        return sb.toString();
    }

    @Override
    public List<String> usedColumns(Set<String> availableColumns) {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.obj.usedColumns(availableColumns));
        if (this.inList != null) {
            for (Expression expr : this.inList) {
                result.addAll(expr.usedColumns(availableColumns));
            }
        }
        if (this.subQuery != null) {
            result.addAll(this.subQuery.usedColumns(availableColumns));
        }
        return result;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> result = new LinkedList<AggregateFunction>();
        if (this.inList != null) {
            for (Expression expr : this.inList) {
                result.addAll(expr.aggregateFunctions());
            }
        }
        if (this.subQuery != null) {
            result.addAll(this.subQuery.aggregateFunctions());
        }
        return result;
    }
}

