/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class CsvResultSetMetaData
implements ResultSetMetaData {
    private String[] columnNames;
    private String[] columnLabels;
    private String[] columnTypes;
    private int[] columnDisplaySizes;
    private String tableName;
    private Map<String, Integer> typeNameToTypeCode = new HashMap<String, Integer>(){
        private static final long serialVersionUID = -8819579540085202365L;
        {
            this.put("String", new Integer(12));
            this.put("Boolean", new Integer(16));
            this.put("Byte", new Integer(-6));
            this.put("Short", new Integer(5));
            this.put("Int", new Integer(4));
            this.put("Integer", new Integer(4));
            this.put("Long", new Integer(-5));
            this.put("Float", new Integer(6));
            this.put("Double", new Integer(8));
            this.put("BigDecimal", new Integer(3));
            this.put("Date", new Integer(91));
            this.put("Time", new Integer(92));
            this.put("Timestamp", new Integer(93));
            this.put("Blob", new Integer(2004));
            this.put("Clob", new Integer(2005));
            this.put("expression", new Integer(2004));
        }
    };

    CsvResultSetMetaData(String tableName, String[] columnNames, String[] columnLabels, String[] columnTypes, int[] columnDisplaySizes) {
        this.tableName = tableName;
        this.columnNames = columnNames;
        this.columnLabels = columnLabels;
        this.columnTypes = columnTypes;
        this.columnDisplaySizes = columnDisplaySizes;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.columnTypes[column - 1];
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnTypes.length;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.columnDisplaySizes[column - 1];
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 2;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return false;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.columnLabels[column - 1];
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.columnNames[column - 1];
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        return 0;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.tableName;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        String columnTypeName = this.getColumnTypeName(column);
        Integer value = this.typeNameToTypeCode.get(columnTypeName);
        return value;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.columnTypes[column - 1];
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        return null;
    }
}

