/*
 * Decompiled with CFR 0.152.
 */
package org.relique.io;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.relique.io.CryptoFilter;

public class EncryptedFileOutputStream
extends OutputStream {
    private OutputStream out;
    private CryptoFilter filter;

    public EncryptedFileOutputStream(String fileName, CryptoFilter filter) throws FileNotFoundException {
        this.filter = filter;
        this.filter.reset();
        this.out = new FileOutputStream(fileName);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.filter == null) {
            this.out.write(b);
        } else {
            this.filter.write(this.out, b);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
    }
}

