/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTreeFilterObjectType;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorView;
import org.jkiss.utils.CommonUtils;

public class NavigatorHandlerFilterObjectType
extends AbstractHandler
implements IElementUpdater {
    private static final Log log = Log.getLog(NavigatorHandlerFilterObjectType.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart activePart;
        DatabaseNavigatorTree navigatorTree = DatabaseNavigatorTree.getFromShell(HandlerUtil.getActiveShell((ExecutionEvent)event));
        if (navigatorTree == null && (activePart = HandlerUtil.getActivePart((ExecutionEvent)event)) instanceof DatabaseNavigatorView) {
            navigatorTree = ((DatabaseNavigatorView)activePart).getNavigatorTree();
        }
        if (navigatorTree != null) {
            DatabaseNavigatorTreeFilterObjectType objectType = (DatabaseNavigatorTreeFilterObjectType)CommonUtils.valueOf(DatabaseNavigatorTreeFilterObjectType.class, (String)event.getParameter("type"), (Enum)DatabaseNavigatorTreeFilterObjectType.table);
            if (objectType == navigatorTree.getFilterObjectType()) {
                return null;
            }
            navigatorTree.setFilterObjectType(objectType);
            navigatorTree.getViewer().getControl().setRedraw(false);
            try {
                navigatorTree.getViewer().refresh();
            }
            finally {
                navigatorTree.getViewer().getControl().setRedraw(true);
            }
            ActionUtils.fireCommandRefresh((String[])new String[]{"org.jkiss.dbeaver.navigator.filter.connected"});
        } else {
            log.debug((Object)"Can't find active navigator tree");
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        IWorkbenchPartSite partSite;
        DatabaseNavigatorTreeFilterObjectType objectType = (DatabaseNavigatorTreeFilterObjectType)CommonUtils.valueOf(DatabaseNavigatorTreeFilterObjectType.class, (String)CommonUtils.toString(parameters.get("type")), (Enum)DatabaseNavigatorTreeFilterObjectType.table);
        DatabaseNavigatorTreeFilterObjectType curObjectType = DatabaseNavigatorTreeFilterObjectType.table;
        DatabaseNavigatorTree navigatorTree = DatabaseNavigatorTree.getFromShell(Display.getCurrent());
        if (navigatorTree == null && (partSite = UIUtils.getWorkbenchPartSite((IServiceLocator)element.getServiceLocator())) != null && partSite.getPart() instanceof DatabaseNavigatorView) {
            navigatorTree = ((DatabaseNavigatorView)partSite.getPart()).getNavigatorTree();
        }
        if (navigatorTree != null) {
            curObjectType = navigatorTree.getFilterObjectType();
        }
        element.setText(objectType.getName());
        element.setTooltip(objectType.getDescription());
        element.setChecked(objectType == curObjectType);
    }
}

