/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.jdbc.SybConnection;
import com.sybase.jdbc4.jdbc.SybResultSet;
import com.sybase.jdbc4.tds.TdsEventContext;
import com.sybase.jdbcx.SybEventHandler;
import java.sql.SQLException;
import java.sql.SQLWarning;

public class EventThread
implements Runnable {
    protected boolean _threadState;
    private TdsEventContext _tec;
    private SybEventHandler _hdlr;
    private String _procName;
    protected int _eventCount;
    private SybResultSet _params;
    private volatile boolean _running = true;

    protected EventThread(TdsEventContext tdsEventContext) {
        this._tec = tdsEventContext;
        this._eventCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this._running) {
            Object object = this;
            synchronized (object) {
                if (this._eventCount == 0) {
                    this._threadState = true;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    this._threadState = false;
                }
            }
            this._procName = null;
            this._params = null;
            this._hdlr = null;
            try {
                this._tec.beginRequest();
                this._procName = this._tec.getProcName();
                this._params = this._tec.getParams();
                this._hdlr = this._tec.getHandler(this._procName);
            }
            catch (SQLException sQLException) {
                this._tec.chainException(sQLException);
            }
            if (this._hdlr == null) {
                this._tec._conn.chainWarnings(this._tec._chainedSqe);
                this._tec._chainedSqe = null;
                object = this;
                synchronized (object) {
                    --this._eventCount;
                    continue;
                }
            }
            if (this._params == null) {
                this._params = this._tec.makeEmptyParams();
            }
            object = SybConnection.convertToWarnings(this._tec._chainedSqe);
            if (this._tec._trsForEvent._warning == null) {
                this._tec._trsForEvent._warning = object;
            } else {
                this._tec._trsForEvent._warning.setNextWarning((SQLWarning)object);
            }
            this._hdlr.event(this._procName, this._params);
            try {
                this._params.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            EventThread eventThread = this;
            synchronized (eventThread) {
                --this._eventCount;
            }
        }
    }

    public void stop() {
        this._running = false;
    }
}

