/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DesktopPlatform;
import org.jkiss.dbeaver.model.app.DBPPlatformLanguage;
import org.jkiss.dbeaver.model.app.DBPPlatformLanguageManager;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.registry.TimezoneRegistry;
import org.jkiss.dbeaver.registry.language.PlatformLanguageDescriptor;
import org.jkiss.dbeaver.registry.language.PlatformLanguageRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.contentassist.ContentAssistUtils;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageDatabaseUserInterface
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main";
    private Button automaticUpdateCheck;
    private Combo workspaceLanguage;
    private Combo clientTimezone;
    private Button longOperationsCheck;
    private Spinner longOperationsTimeout;
    private Button notificationsEnabled;
    private Spinner notificationsCloseDelay;
    private boolean isStandalone = DesktopPlatform.isStandalone();

    public PrefPageDatabaseUserInterface() {
        this.setPreferenceStore((IPreferenceStore)new PreferenceStoreDelegate(DBWorkbench.getPlatform().getPreferenceStore()));
    }

    public void init(IWorkbench workbench) {
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        if (this.isStandalone) {
            Group groupObjects = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_ui_general_group_general, (int)2, (int)2, (int)0);
            this.automaticUpdateCheck = UIUtils.createCheckbox((Composite)groupObjects, (String)CoreMessages.pref_page_ui_general_checkbox_automatic_updates, null, (boolean)false, (int)2);
        }
        if (this.isStandalone) {
            Group groupLanguage = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_ui_general_group_language, (int)2, (int)2, (int)0);
            this.workspaceLanguage = UIUtils.createLabelCombo((Composite)groupLanguage, (String)CoreMessages.pref_page_ui_general_combo_language, (String)CoreMessages.pref_page_ui_general_combo_language_tip, (int)12);
            this.workspaceLanguage.setLayoutData((Object)new GridData(32));
            List languages = PlatformLanguageRegistry.getInstance().getLanguages();
            DBPPlatformLanguage pLanguage = DBWorkbench.getPlatform().getLanguage();
            int i = 0;
            while (i < languages.size()) {
                PlatformLanguageDescriptor lang = (PlatformLanguageDescriptor)languages.get(i);
                this.workspaceLanguage.add(lang.getLabel());
                if (CommonUtils.equalObjects((Object)pLanguage, (Object)lang)) {
                    this.workspaceLanguage.select(i);
                }
                ++i;
            }
            if (this.workspaceLanguage.getSelectionIndex() < 0) {
                this.workspaceLanguage.select(0);
            }
            Label tipLabel = UIUtils.createLabel((Composite)groupLanguage, (String)CoreMessages.pref_page_ui_general_label_options_take_effect_after_restart);
            tipLabel.setLayoutData((Object)new GridData(32, 2, false, false, 2, 1));
        }
        if (this.isStandalone) {
            Group clientTimezoneGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_ui_general_group_timezone, (int)2, (int)770, (int)0);
            this.clientTimezone = UIUtils.createLabelCombo((Composite)clientTimezoneGroup, (String)CoreMessages.pref_page_ui_general_combo_timezone, (String)CoreMessages.pref_page_ui_general_combo_timezone_tip, (int)4);
            this.clientTimezone.setLayoutData((Object)new GridData(32));
            this.clientTimezone.add("Default");
            for (String timezoneName : TimezoneRegistry.getTimezoneNames()) {
                this.clientTimezone.add(timezoneName);
            }
            this.clientTimezone.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PrefPageDatabaseUserInterface.this.updateApplyButton();
                    PrefPageDatabaseUserInterface.this.getContainer().updateButtons();
                }
            });
            IContentProposalProvider proposalProvider = (contents, position) -> {
                ArrayList<ContentProposal> proposals = new ArrayList<ContentProposal>();
                String[] stringArray = this.clientTimezone.getItems();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    if (item.toLowerCase().contains(contents.toLowerCase())) {
                        proposals.add(new ContentProposal(item));
                    }
                    ++n2;
                }
                return (IContentProposal[])proposals.toArray(IContentProposal[]::new);
            };
            ContentAssistUtils.installContentProposal((Control)this.clientTimezone, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)proposalProvider);
        }
        Group notificationsGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_ui_general_group_notifications, (int)2, (int)770, (int)0);
        this.notificationsEnabled = UIUtils.createCheckbox((Composite)notificationsGroup, (String)CoreMessages.pref_page_ui_general_label_enable_notifications, (String)CoreMessages.pref_page_ui_general_label_enable_notifications_tip, (boolean)false, (int)2);
        this.notificationsCloseDelay = UIUtils.createLabelSpinner((Composite)notificationsGroup, (String)CoreMessages.pref_page_ui_general_label_notifications_close_delay, (int)0, (int)0, (int)Integer.MAX_VALUE);
        Group agentGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_ui_general_group_task_bar, (int)2, (int)770, (int)0);
        this.longOperationsCheck = UIUtils.createCheckbox((Composite)agentGroup, (String)CoreMessages.pref_page_ui_general_label_enable_long_operations, (String)CoreMessages.pref_page_ui_general_label_enable_long_operations_tip, (boolean)false, (int)2);
        this.longOperationsTimeout = UIUtils.createLabelSpinner((Composite)agentGroup, (String)(String.valueOf(CoreMessages.pref_page_ui_general_label_long_operation_timeout) + UIMessages.label_sec), (int)0, (int)0, (int)Integer.MAX_VALUE);
        if (RuntimeUtils.isMacOS()) {
            ControlEnableState.disable((Control)agentGroup);
        }
        this.performDefaults();
        return composite;
    }

    protected void performDefaults() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        if (this.isStandalone) {
            this.automaticUpdateCheck.setSelection(store.getBoolean("ui.auto.update.check"));
        }
        this.notificationsEnabled.setSelection(store.getBoolean("notifications.enabled"));
        this.notificationsCloseDelay.setSelection(store.getInt("notifications.closeDelay"));
        String string = store.getString("java.client.timezone");
        if (string.equals("Default")) {
            this.clientTimezone.setText("Default");
        } else {
            this.clientTimezone.setText(TimezoneRegistry.getGMTString((String)string));
        }
        this.longOperationsCheck.setSelection(store.getBoolean("agent.long.operation.notify"));
        this.longOperationsTimeout.setSelection(store.getInt("agent.long.operation.timeout"));
    }

    public boolean isValid() {
        return super.isValid() && this.clientTimezone != null && Arrays.stream(this.clientTimezone.getItems()).anyMatch(s -> s.equals(this.clientTimezone.getText()));
    }

    public boolean performOk() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        if (this.isStandalone) {
            store.setValue("ui.auto.update.check", this.automaticUpdateCheck.getSelection());
        }
        store.setValue("notifications.enabled", this.notificationsEnabled.getSelection());
        store.setValue("notifications.closeDelay", this.notificationsCloseDelay.getSelection());
        store.setValue("agent.long.operation.notify", this.longOperationsCheck.getSelection());
        store.setValue("agent.long.operation.timeout", this.longOperationsTimeout.getSelection());
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        if (this.clientTimezone.getText().equals("Default")) {
            TimezoneRegistry.setDefaultZone(null);
        } else {
            TimezoneRegistry.setDefaultZone((ZoneId)ZoneId.of(TimezoneRegistry.extractTimezoneId((String)this.clientTimezone.getText())));
        }
        if (this.workspaceLanguage.getSelectionIndex() >= 0) {
            PlatformLanguageDescriptor language = (PlatformLanguageDescriptor)PlatformLanguageRegistry.getInstance().getLanguages().get(this.workspaceLanguage.getSelectionIndex());
            DBPPlatformLanguage curLanguage = DBWorkbench.getPlatform().getLanguage();
            try {
                if (curLanguage != language) {
                    ((DBPPlatformLanguageManager)DBWorkbench.getPlatform()).setPlatformLanguage((DBPPlatformLanguage)language);
                    if (UIUtils.confirmAction((Shell)this.getShell(), (String)("Restart " + GeneralUtils.getProductName()), (String)("You need to restart " + GeneralUtils.getProductName() + " to perform actual language change.\nDo you want to restart?"))) {
                        UIUtils.asyncExec(() -> {
                            boolean bl = PlatformUI.getWorkbench().restart();
                        });
                    }
                }
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Change language", "Can't switch language to " + language, (Throwable)e);
            }
        }
        return true;
    }

    @Nullable
    public IAdaptable getElement() {
        return null;
    }

    public void setElement(IAdaptable element) {
    }
}

