/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.eula;

import java.util.prefs.Preferences;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IWorkbenchWindowInitializer;
import org.jkiss.dbeaver.ui.eula.EULAUtils;

public class EULAInitializer
implements IWorkbenchWindowInitializer {
    public static final String DBEAVER_EULA = "DBeaver.eula";

    public void initializeWorkbenchWindow(@NotNull IWorkbenchWindow window) {
        if (!DBWorkbench.getPlatform().getApplication().isStandalone() || !this.isEulaDialogNeeded() || window.getWorkbench().getWorkbenchWindowCount() > 1) {
            return;
        }
        EULAUtils.showEula(window.getShell(), true);
    }

    private boolean isEulaDialogNeeded() {
        Preferences preferences = Preferences.userNodeForPackage(DBWorkbench.getPlatform().getApplication().getClass());
        if (preferences.get(DBEAVER_EULA, null) == null || !preferences.get(DBEAVER_EULA, null).equals(EULAUtils.getEulaVersion())) {
            preferences.remove(DBEAVER_EULA);
            return true;
        }
        return false;
    }
}

