/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPConnectionEventType;
import org.jkiss.dbeaver.model.connection.DataSourceVariableResolver;
import org.jkiss.dbeaver.model.runtime.DBRShellCommand;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFolder;
import org.jkiss.dbeaver.ui.controls.VariablesHintLabel;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionWizardPage;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class ConnectionPageShellCommands
extends ConnectionWizardPage {
    public static final String PAGE_NAME = ConnectionPageShellCommands.class.getSimpleName();
    private static final String CoreMessagesdialog_connection_edit_wizard_shell_cmd_directory_title = null;
    private DataSourceDescriptor dataSource;
    private Text commandText;
    private Button showProcessCheck;
    private Button waitFinishCheck;
    private Spinner waitFinishTimeoutMs;
    private Button terminateCheck;
    private Spinner pauseAfterExecute;
    private TextWithOpenFolder workingDirectory;
    private Table eventTypeTable;
    private final Map<DBPConnectionEventType, DBRShellCommand> eventsCache = new HashMap<DBPConnectionEventType, DBRShellCommand>();

    protected ConnectionPageShellCommands(DataSourceDescriptor dataSource) {
        super(PAGE_NAME);
        this.dataSource = dataSource;
        this.setTitle(CoreMessages.dialog_connection_edit_wizard_shell_cmd);
        this.setDescription(CoreMessages.dialog_connection_events_title);
        this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.EVENT));
        DBPConnectionEventType[] dBPConnectionEventTypeArray = DBPConnectionEventType.values();
        int n = dBPConnectionEventTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPConnectionEventType eventType = dBPConnectionEventTypeArray[n2];
            DBRShellCommand command = dataSource.getConnectionConfiguration().getEvent(eventType);
            this.eventsCache.put(eventType, command == null ? null : new DBRShellCommand(command));
            ++n2;
        }
    }

    public void createControl(Composite parent) {
        Composite group = UIUtils.createPlaceholder((Composite)parent, (int)2, (int)5);
        group.setLayoutData((Object)new GridData(1808));
        Composite eventGroup = UIUtils.createPlaceholder((Composite)group, (int)1);
        eventGroup.setLayoutData((Object)new GridData(1040));
        UIUtils.createControlLabel((Composite)eventGroup, (String)CoreMessages.dialog_connection_events_label_event);
        this.eventTypeTable = new Table(eventGroup, 67620);
        this.eventTypeTable.setLayoutData((Object)new GridData(1040));
        this.eventTypeTable.addListener(13, event -> {
            if (event.detail == 32) {
                this.eventTypeTable.select(this.eventTypeTable.indexOf((TableItem)event.item));
            }
        });
        DBPConnectionEventType[] dBPConnectionEventTypeArray = DBPConnectionEventType.values();
        int n = dBPConnectionEventTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPConnectionEventType eventType = dBPConnectionEventTypeArray[n2];
            DBRShellCommand command = this.eventsCache.get(eventType);
            TableItem item = new TableItem(this.eventTypeTable, 0);
            item.setData((Object)eventType);
            item.setText(eventType.getTitle());
            item.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.EVENT));
            item.setChecked(command != null && command.isEnabled());
            ++n2;
        }
        this.eventTypeTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBPConnectionEventType eventType = ConnectionPageShellCommands.this.getSelectedEventType();
                ConnectionPageShellCommands.this.selectEventType(eventType);
                DBRShellCommand command = eventType == null ? null : ConnectionPageShellCommands.this.eventsCache.get(eventType);
                boolean enabled = ((TableItem)e.item).getChecked();
                if (enabled || command != null && enabled != command.isEnabled()) {
                    ConnectionPageShellCommands.this.updateEvent(false);
                }
            }
        });
        Composite detailsGroup = UIUtils.createComposite((Composite)group, (int)2);
        detailsGroup.setLayoutData((Object)new GridData(1808));
        UIUtils.createControlLabel((Composite)detailsGroup, (String)CoreMessages.dialog_connection_events_label_command, (int)2);
        this.commandText = new Text(detailsGroup, 2626);
        this.commandText.addModifyListener(e -> this.updateEvent(true));
        GridData gd = new GridData(768);
        gd.heightHint = 120;
        gd.widthHint = 300;
        gd.horizontalSpan = 2;
        this.commandText.setLayoutData((Object)gd);
        SelectionAdapter eventEditAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionPageShellCommands.this.updateEvent(false);
            }
        };
        Group settingsGroup = UIUtils.createControlGroup((Composite)detailsGroup, (String)CoreMessages.dialog_connection_events_settings_group, (int)2, (int)768, (int)0);
        this.showProcessCheck = UIUtils.createCheckbox((Composite)settingsGroup, (String)CoreMessages.dialog_connection_events_checkbox_show_process, (boolean)false);
        this.showProcessCheck.addSelectionListener((SelectionListener)eventEditAdapter);
        this.showProcessCheck.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.terminateCheck = UIUtils.createCheckbox((Composite)settingsGroup, (String)CoreMessages.dialog_connection_events_checkbox_terminate_at_disconnect, (boolean)false);
        this.terminateCheck.addSelectionListener((SelectionListener)eventEditAdapter);
        this.terminateCheck.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.waitFinishCheck = UIUtils.createCheckbox((Composite)settingsGroup, (String)CoreMessages.dialog_connection_events_checkbox_wait_finish, (boolean)false);
        this.waitFinishCheck.addSelectionListener((SelectionListener)eventEditAdapter);
        this.waitFinishTimeoutMs = UIUtils.createSpinner((Composite)settingsGroup, (String)CoreMessages.dialog_connection_events_checkbox_wait_finish_timeout, (int)0, (int)-1, (int)99999);
        this.waitFinishTimeoutMs.addSelectionListener((SelectionListener)eventEditAdapter);
        this.pauseAfterExecute = UIUtils.createLabelSpinner((Composite)settingsGroup, (String)CoreMessages.dialog_connection_edit_wizard_shell_cmd_pause_label, (String)CoreMessages.dialog_connection_edit_wizard_shell_cmd_pause_tooltip, (int)0, (int)0, (int)Integer.MAX_VALUE);
        this.pauseAfterExecute.addSelectionListener((SelectionListener)eventEditAdapter);
        UIUtils.createControlLabel((Composite)settingsGroup, (String)CoreMessages.dialog_connection_edit_wizard_shell_cmd_directory_label);
        this.workingDirectory = new TextWithOpenFolder((Composite)settingsGroup, CoreMessagesdialog_connection_edit_wizard_shell_cmd_directory_title);
        this.workingDirectory.setLayoutData((Object)new GridData(768));
        this.workingDirectory.getTextControl().addModifyListener(e -> {
            DBRShellCommand command = this.getActiveCommand();
            if (command != null) {
                command.setWorkingDirectory(this.workingDirectory.getText());
            }
        });
        VariablesHintLabel variablesHintLabel = new VariablesHintLabel(detailsGroup, CoreMessages.dialog_connection_edit_wizard_shell_cmd_variables_hint_label, CoreMessages.dialog_connection_edit_wizard_shell_cmd_variables_hint_title, DBPConnectionConfiguration.CONNECT_VARIABLES);
        variablesHintLabel.setResolver((IVariableResolver)new DataSourceVariableResolver((DBPDataSourceContainer)this.dataSource, this.dataSource.getConnectionConfiguration()));
        this.selectEventType(null);
        this.setControl((Control)group);
    }

    private DBPConnectionEventType getSelectedEventType() {
        Object[] selection = this.eventTypeTable.getSelection();
        return ArrayUtils.isEmpty((Object[])selection) ? null : (DBPConnectionEventType)selection[0].getData();
    }

    private TableItem getEventItem(DBPConnectionEventType eventType) {
        TableItem[] tableItemArray = this.eventTypeTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getData() == eventType) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    private DBRShellCommand getActiveCommand() {
        DBPConnectionEventType eventType = this.getSelectedEventType();
        if (eventType != null) {
            DBRShellCommand command = this.eventsCache.get(eventType);
            if (command == null) {
                command = new DBRShellCommand("");
                this.eventsCache.put(eventType, command);
            }
            return command;
        }
        return null;
    }

    private void updateEvent(boolean commandChange) {
        DBPConnectionEventType eventType = this.getSelectedEventType();
        DBRShellCommand command = this.getActiveCommand();
        if (command != null) {
            boolean prevEnabled = command.isEnabled();
            if (commandChange) {
                command.setCommand(this.commandText.getText());
            } else {
                TableItem item = this.getEventItem(eventType);
                if (item != null) {
                    command.setEnabled(item.getChecked());
                }
                command.setShowProcessPanel(this.showProcessCheck.getSelection());
                command.setWaitProcessFinish(this.waitFinishCheck.getSelection());
                this.waitFinishTimeoutMs.setEnabled(this.waitFinishCheck.getSelection());
                command.setWaitProcessTimeoutMs(this.waitFinishTimeoutMs.getSelection());
                command.setTerminateAtDisconnect(this.terminateCheck.getSelection());
                command.setPauseAfterExecute(this.pauseAfterExecute.getSelection());
                command.setWorkingDirectory(this.workingDirectory.getText());
                if (prevEnabled != command.isEnabled()) {
                    this.selectEventType(eventType);
                }
            }
        } else if (!commandChange) {
            this.selectEventType(null);
        }
    }

    private void selectEventType(DBPConnectionEventType eventType) {
        DBRShellCommand command = eventType == null ? null : this.eventsCache.get(eventType);
        this.commandText.setEnabled(command != null && command.isEnabled());
        this.showProcessCheck.setEnabled(command != null && command.isEnabled());
        this.waitFinishCheck.setEnabled(command != null && command.isEnabled());
        this.waitFinishTimeoutMs.setEnabled(this.waitFinishCheck.isEnabled());
        this.terminateCheck.setEnabled(command != null && command.isEnabled());
        this.pauseAfterExecute.setEnabled(command != null && command.isEnabled());
        this.workingDirectory.setEnabled(command != null && command.isEnabled());
        this.workingDirectory.getTextControl().setEnabled(command != null && command.isEnabled());
        if (command != null) {
            this.commandText.setText(CommonUtils.toString((Object)command.getCommand()));
            this.showProcessCheck.setSelection(command.isShowProcessPanel());
            this.waitFinishCheck.setSelection(command.isWaitProcessFinish());
            this.waitFinishTimeoutMs.setSelection(command.getWaitProcessTimeoutMs());
            this.terminateCheck.setSelection(command.isTerminateAtDisconnect());
            this.pauseAfterExecute.setSelection(command.getPauseAfterExecute());
            this.workingDirectory.setText(CommonUtils.notEmpty((String)command.getWorkingDirectory()));
        } else {
            this.commandText.setText("");
            this.showProcessCheck.setSelection(false);
            this.waitFinishCheck.setSelection(false);
            this.waitFinishTimeoutMs.setSelection(-1);
            this.terminateCheck.setSelection(false);
            this.pauseAfterExecute.setSelection(0);
            this.workingDirectory.setText("");
        }
    }

    @Override
    public void saveSettings(DBPDataSourceContainer dataSourceDescriptor) {
        for (Map.Entry<DBPConnectionEventType, DBRShellCommand> entry : this.eventsCache.entrySet()) {
            dataSourceDescriptor.getConnectionConfiguration().setEvent(entry.getKey(), entry.getValue());
        }
    }
}

