/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.transfer.processor;

import com.dbeaver.data.transfer.mail.SMTPProfile;
import com.dbeaver.data.transfer.mail.SMTPProfileManager;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferEventProcessor;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferConsumer;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class SendMailEventProcessor
implements IDataTransferEventProcessor<StreamTransferConsumer> {
    public static final String PROP_PROFILE = "profile";
    public static final String PROP_RECIPIENT = "recipient";
    public static final String PROP_SUBJECT = "subject";

    public void processEvent(@NotNull DBRProgressMonitor monitor, @NotNull IDataTransferEventProcessor.Event event, @NotNull StreamTransferConsumer consumer, @NotNull Map<String, Object> processorSettings) throws DBException {
        SMTPProfile profile = SMTPProfileManager.getProfile(CommonUtils.toString((Object)processorSettings.get(PROP_PROFILE)));
        String recipient = CommonUtils.toString((Object)processorSettings.get(PROP_RECIPIENT));
        String subject = CommonUtils.toString((Object)processorSettings.get(PROP_SUBJECT));
        if (profile == null || CommonUtils.isEmptyTrimmed((String)recipient) || CommonUtils.isEmptyTrimmed((String)subject)) {
            throw new DBException("Invalid E-Mail configuration");
        }
        Properties properties = new Properties();
        properties.put("mail.smtp.host", profile.getHostname());
        properties.put("mail.smtp.port", (Object)profile.getPort());
        properties.put("mail.smtp.auth", (Object)true);
        properties.put("mail.smtp.starttls.enable", (Object)true);
        Session session = Session.getInstance((Properties)properties, (Authenticator)profile.createAuthenticator());
        try {
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart body = new MimeBodyPart();
            body.setContent((Object)("Sent by " + GeneralUtils.getProductName()), "text/plain; charset=UTF-8");
            multipart.addBodyPart((BodyPart)body);
            for (File file : consumer.getOutputFiles()) {
                MimeBodyPart attachment = new MimeBodyPart();
                attachment.attachFile(file);
                multipart.addBodyPart((BodyPart)attachment);
            }
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(profile.getUsername()));
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)recipient));
            message.setSubject(subject);
            message.setContent((Multipart)multipart);
            try {
                monitor.beginTask("Send mail", 1);
                Transport.send((Message)message);
            }
            finally {
                monitor.done();
            }
        }
        catch (Exception e) {
            throw new DBException("Error sending E-Mail message", (Throwable)e);
        }
    }
}

