/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.lm.validate;

import com.dbeaver.lm.internal.core.LMMessages;
import com.dbeaver.lm.validate.LicenseCheckResult;
import com.dbeaver.lm.validate.LicenseRequest;
import com.dbeaver.lm.validate.PublicServiceClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.lm.LMException;
import org.jkiss.lm.LMLicense;
import org.jkiss.lm.LMLicenseManager;
import org.jkiss.lm.LMLicenseStatus;
import org.jkiss.lm.LMProduct;
import org.jkiss.lm.LMSubscription;
import org.jkiss.lm.LMUtils;
import org.jkiss.utils.CommonUtils;

public class LMPublicAPI {
    public static final String BUNDLE_SYMBOLIC_NAME = "com.dbeaver.lm.core";
    private static final Log log = Log.getLog(LMPublicAPI.class);
    private static final int LICENSE_CHECK_TIMEOUT = 4000;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LicenseCheckResult checkLicenseStatus(IProgressMonitor monitor, String clientId, LMLicenseManager licenseManager, LMLicense license, LMProduct product) {
        monitor.beginTask("Check license status", 3);
        try {
            String licenseUpdate;
            boolean needsUpdate;
            LicenseCheckResult checkResult;
            PublicServiceClient client;
            block24: {
                LMLicenseStatus licenseStatus;
                BufferedReader br;
                client = new PublicServiceClient(clientId, 4000, 4000);
                try {
                    monitor.subTask("Validate license " + license.getLicenseId());
                    String licenseStatusText = client.checkLicenseStatus(license, product);
                    if (CommonUtils.isEmpty((String)licenseStatusText)) {
                        LicenseCheckResult licenseCheckResult = new LicenseCheckResult(Status.OK_STATUS, LMLicenseStatus.VALID);
                        return licenseCheckResult;
                    }
                    br = new BufferedReader(new StringReader(licenseStatusText));
                }
                catch (Exception e) {
                    LicenseCheckResult licenseCheckResult2 = new LicenseCheckResult(GeneralUtils.makeErrorStatus((String)"Error checking license status", (Throwable)e), LMLicenseStatus.VALID);
                    return licenseCheckResult2;
                }
                String licenseStatusString = br.readLine();
                monitor.worked(1);
                int divPos = licenseStatusString.indexOf(58);
                if (divPos == -1) {
                    LicenseCheckResult licenseCheckResult = new LicenseCheckResult(GeneralUtils.makeErrorStatus((String)("Bad check status: " + licenseStatusString)), LMLicenseStatus.INVALID);
                    return licenseCheckResult;
                }
                String statusCode = licenseStatusString.substring(0, divPos).trim();
                String statusMessage = licenseStatusString.substring(divPos + 1).trim();
                try {
                    licenseStatus = LMLicenseStatus.valueOf((String)statusCode);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    log.debug((Object)("Bad license status: [" + statusCode + "]"));
                    licenseStatus = LMLicenseStatus.VALID;
                }
                checkResult = new LicenseCheckResult(GeneralUtils.makeInfoStatus((String)statusMessage), licenseStatus);
                needsUpdate = false;
                StringBuilder subscriptionInfo = new StringBuilder();
                boolean inSubscription = false;
                while (true) {
                    String line;
                    if ((line = br.readLine()) == null) {
                        if (license.isSubscription()) {
                            break;
                        }
                        break block24;
                    }
                    if (CommonUtils.isEmpty((String)line)) continue;
                    if (line.startsWith("-- LICENSE_UPDATE")) {
                        needsUpdate = true;
                        inSubscription = false;
                        continue;
                    }
                    if (line.startsWith("-- SUBSCRIPTION")) {
                        inSubscription = true;
                        continue;
                    }
                    if (!inSubscription) continue;
                    subscriptionInfo.append(line).append("\n");
                }
                if (subscriptionInfo.length() > 0) {
                    try {
                        byte[] subEncrypted = LMUtils.readEncryptedString((Reader)new StringReader(subscriptionInfo.toString()));
                        LMSubscription subscription = licenseManager.readSubscriptionFromData(product, subEncrypted);
                        checkResult.setSubscription(subscription);
                    }
                    catch (IOException e) {
                        log.debug((Object)"Error reading subscription info", (Throwable)e);
                    }
                }
            }
            if (needsUpdate && !CommonUtils.isEmpty((String)(licenseUpdate = client.getLicenseUpdate(license, product)))) {
                try {
                    LMLicense updatedLicense = licenseManager.readStandardLicense(product, licenseUpdate);
                    if (updatedLicense != null) {
                        licenseManager.importLicense(product, updatedLicense);
                        log.info((Object)"License info was updated from the server");
                    }
                }
                catch (LMException e) {
                    log.error((Object)"License update read failed", (Throwable)e);
                }
            }
            LicenseCheckResult licenseCheckResult = checkResult;
            return licenseCheckResult;
        }
        finally {
            monitor.done();
        }
    }

    @NotNull
    public static IStatus requestTrialLicense(@NotNull DBRProgressMonitor monitor, @NotNull String clientId, @NotNull LMProduct product, @NotNull LicenseRequest request) {
        PublicServiceClient client = new PublicServiceClient(clientId);
        try {
            monitor.beginTask("Request trial license", 2);
            try {
                monitor.subTask("Check license server");
                log.debug((Object)"Ping license server");
                log.debug((Object)("Ping result: " + client.ping()));
                monitor.worked(1);
            }
            catch (Exception e) {
                IStatus iStatus = GeneralUtils.makeErrorStatus((String)NLS.bind((String)LMMessages.api_trial_license_request_error_ping_failed, (Object)"dbeaver.com", (Object)e.getMessage()));
                monitor.done();
                return iStatus;
            }
            try {
                monitor.subTask("Generate license");
                log.debug((Object)"Request trial license");
                client.requestTrialLicense(product, request);
                monitor.worked(1);
            }
            catch (Exception e) {
                IStatus iStatus = GeneralUtils.makeErrorStatus((String)NLS.bind((String)LMMessages.api_trial_license_request_error_request_failed, (Object)e.getMessage()));
                monitor.done();
                return iStatus;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }
}

