/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redis.views;

import com.dbeaver.db.redis.Activator;
import com.dbeaver.db.redis.RedisMessages;
import com.dbeaver.db.redis.views.RedisKeysConfigPage;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.utils.CommonUtils;

public class RedisConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider {
    private static final Log log = Log.getLog(RedisConnectionPage.class);
    private static ImageDescriptor logoImage = Activator.getImageDescriptor("icons/redis_logo.png");
    private Composite settingsGroup;
    private Text hostText;
    private Text portText;
    private Combo databaseText;
    private Text connectTimeout;
    private Text socketTimeout;
    private boolean activated;
    private Button clusterCheck;
    private Button setClientCheck;

    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        this.createGeneralTab(composite);
        this.setControl((Control)this.settingsGroup);
    }

    private Composite createGeneralTab(Composite parent) {
        ModifyListener textListener = e -> {
            if (this.activated) {
                this.saveAndUpdate();
            }
        };
        this.settingsGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        this.settingsGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        this.settingsGroup.setLayoutData((Object)gd);
        Group serverGroup = UIUtils.createControlGroup((Composite)this.settingsGroup, (String)RedisMessages.connection_page_group_server, (int)4, (int)768, (int)-1);
        this.hostText = UIUtils.createLabelText((Composite)serverGroup, (String)RedisMessages.connection_page_group_host, (String)"");
        gd = new GridData(768);
        this.hostText.setLayoutData((Object)gd);
        this.hostText.addModifyListener(textListener);
        this.portText = UIUtils.createLabelText((Composite)serverGroup, (String)RedisMessages.connection_page_label_text_port, (String)"");
        gd = new GridData(2);
        gd.widthHint = 60;
        this.portText.setLayoutData((Object)gd);
        this.portText.addModifyListener(textListener);
        this.databaseText = UIUtils.createLabelCombo((Composite)serverGroup, (String)RedisMessages.connection_page_label_text_database, (String)RedisMessages.connection_page_label_text_database_tip, (int)2060);
        gd = new GridData(32);
        gd.widthHint = 32;
        this.databaseText.setLayoutData((Object)gd);
        this.databaseText.addModifyListener(textListener);
        int i = 0;
        while (i < 16) {
            this.databaseText.add(String.valueOf(i));
            ++i;
        }
        this.clusterCheck = UIUtils.createCheckbox((Composite)serverGroup, (String)"Cluster", (String)"Use multi-node cluster connection.\nSome Redis features may not work in this mode", (boolean)false, (int)2);
        Group securityGroup = UIUtils.createControlGroup((Composite)this.settingsGroup, (String)"Security", (int)3, (int)768, (int)-1);
        this.createAuthPanel((Composite)securityGroup, 3);
        serverGroup = UIUtils.createControlGroup((Composite)this.settingsGroup, (String)RedisMessages.connection_page_group_connection_settings, (int)4, (int)768, (int)-1);
        this.connectTimeout = UIUtils.createLabelText((Composite)serverGroup, (String)RedisMessages.connection_page_label_spinner_connect_timeout, (String)String.valueOf(10000));
        this.connectTimeout.setToolTipText(RedisMessages.connection_page_label_spinner_tip_connect_timeout);
        gd = new GridData(32);
        gd.widthHint = UIUtils.getFontHeight((Control)this.connectTimeout) * 10;
        this.connectTimeout.setLayoutData((Object)gd);
        this.connectTimeout.addModifyListener(textListener);
        this.socketTimeout = UIUtils.createLabelText((Composite)serverGroup, (String)RedisMessages.connection_page_label_spinner_socket_timeout, (String)String.valueOf(100000));
        this.socketTimeout.setToolTipText(RedisMessages.connection_page_label_spinner_tip_socket_timeout);
        gd = new GridData(2);
        gd.widthHint = UIUtils.getFontHeight((Control)this.socketTimeout) * 10;
        this.socketTimeout.setLayoutData((Object)gd);
        this.socketTimeout.addModifyListener(textListener);
        this.setClientCheck = UIUtils.createCheckbox((Composite)serverGroup, (String)RedisMessages.connection_page_label_set_client, (String)RedisMessages.connection_page_label_set_client_tip, (boolean)true, (int)4);
        this.createDriverPanel(this.settingsGroup);
        return this.settingsGroup;
    }

    public boolean isComplete() {
        return !this.hostText.getText().isEmpty() && !this.portText.getText().isEmpty();
    }

    public void loadSettings() {
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.hostText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                this.hostText.setText(CommonUtils.notEmpty((String)connectionInfo.getHostName()));
            } else {
                this.hostText.setText("localhost");
            }
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                this.portText.setText(connectionInfo.getHostPort());
            } else if (this.site.getDriver().getDefaultPort() != null) {
                this.portText.setText(this.site.getDriver().getDefaultPort());
            } else {
                this.portText.setText("");
            }
            String dbName = connectionInfo.getDatabaseName();
            if (CommonUtils.isEmpty((String)dbName)) {
                dbName = String.valueOf(0);
            }
            this.databaseText.setText(dbName);
            this.clusterCheck.setSelection(CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("redis.use.cluster")));
            String timeout = connectionInfo.getProviderProperty("@dbeaver-redis.timeout.connect");
            if (timeout == null) {
                timeout = String.valueOf(10000);
            }
            this.connectTimeout.setText(timeout);
            timeout = connectionInfo.getProviderProperty("@dbeaver-redis.timeout.socket");
            if (timeout == null) {
                timeout = String.valueOf(100000);
            }
            this.socketTimeout.setText(timeout);
            this.setClientCheck.setSelection(CommonUtils.getBoolean((String)connectionInfo.getProviderProperty("redis.set.client"), (boolean)true));
        }
        super.loadSettings();
        this.activated = true;
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.hostText != null) {
            connectionInfo.setHostName(this.hostText.getText().trim());
            connectionInfo.setHostPort(this.portText.getText().trim());
            connectionInfo.setDatabaseName(this.databaseText.getText().trim());
            connectionInfo.setProviderProperty("redis.use.cluster", String.valueOf(this.clusterCheck.getSelection()));
        }
        connectionInfo.setProviderProperty("@dbeaver-redis.timeout.connect", this.connectTimeout.getText());
        connectionInfo.setProviderProperty("@dbeaver-redis.timeout.socket", this.socketTimeout.getText());
        connectionInfo.setProviderProperty("redis.set.client", String.valueOf(this.setClientCheck.getSelection()));
        super.saveSettings(dataSource);
    }

    private void saveAndUpdate() {
        this.site.updateButtons();
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new RedisKeysConfigPage()};
    }
}

