/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.CharSet;
import com.ingres.gcf.util.SqlChar;
import com.ingres.gcf.util.SqlExFactory;
import com.ingres.gcf.util.SqlLongByte;
import com.ingres.gcf.util.SqlLongNChar;
import com.ingres.gcf.util.SqlStream;
import com.ingres.gcf.util.SqlVarChar;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;

public class SqlLongChar
extends SqlLongNChar {
    private CharSet charSet = null;

    public SqlLongChar(CharSet charSet) {
        this.charSet = charSet;
    }

    public SqlLongChar(CharSet charSet, SqlStream.StreamListener streamListener) {
        super(streamListener);
        this.charSet = charSet;
    }

    public void set(InputStream inputStream) throws SQLException {
        this.setStream(inputStream);
    }

    public void set(SqlChar sqlChar) throws SQLException {
        if (sqlChar.isNull()) {
            this.setNull();
        } else {
            sqlChar.extend();
            this.setStream(SqlLongChar.getBinary(sqlChar.value, 0, sqlChar.length));
        }
    }

    public void set(SqlVarChar sqlVarChar) throws SQLException {
        if (sqlVarChar.isNull()) {
            this.setNull();
        } else {
            this.setStream(SqlLongChar.getBinary(sqlVarChar.value, 0, sqlVarChar.length));
        }
    }

    @Override
    public Reader get() throws SQLException {
        Object object = this.getStream();
        if (object == null) {
            return null;
        }
        if (object instanceof InputStream) {
            return this.cnvtIS2Rdr((InputStream)object);
        }
        if (object instanceof Reader) {
            return (Reader)object;
        }
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    public void get(OutputStream outputStream) throws SQLException {
        Object object = this.getStream();
        if (object != null) {
            if (object instanceof InputStream) {
                SqlLongChar.copyIs2Os((InputStream)object, outputStream);
            } else if (object instanceof Reader) {
                OutputStreamWriter outputStreamWriter;
                try {
                    outputStreamWriter = this.charSet.getOSW(outputStream);
                }
                catch (Exception exception) {
                    throw SqlExFactory.get(ERR_GC401E_CHAR_ENCODE);
                }
                SqlLongChar.copyRdr2Wtr((Reader)object, outputStreamWriter);
            } else {
                throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
            }
        }
    }

    @Override
    public void get(Writer writer) throws SQLException {
        Object object = this.getStream();
        if (object != null) {
            if (object instanceof InputStream) {
                SqlLongChar.copyRdr2Wtr(this.cnvtIS2Rdr((InputStream)object), writer);
            } else if (object instanceof Reader) {
                SqlLongChar.copyRdr2Wtr((Reader)object, writer);
            } else {
                throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
            }
        }
    }

    @Override
    public byte[] getBytes() throws SQLException {
        Object object = this.getStream();
        if (object == null) {
            return null;
        }
        if (object instanceof InputStream) {
            return SqlLongByte.strm2array((InputStream)object);
        }
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        Object object = this.getStream();
        if (object == null) {
            return null;
        }
        if (object instanceof InputStream) {
            return SqlLongByte.strm2array((InputStream)object, n);
        }
        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return this.getBinary();
    }

    @Override
    protected Reader cnvtIS2Rdr(InputStream inputStream) throws SQLException {
        try {
            return this.charSet.getISR(inputStream);
        }
        catch (Exception exception) {
            throw SqlExFactory.get(ERR_GC401E_CHAR_ENCODE);
        }
    }

    public static String strm2str(InputStream inputStream, CharSet charSet) throws SQLException {
        InputStreamReader inputStreamReader;
        try {
            inputStreamReader = charSet.getISR(inputStream);
        }
        catch (Exception exception) {
            throw SqlExFactory.get(ERR_GC401E_CHAR_ENCODE);
        }
        return SqlLongChar.strm2str(inputStreamReader);
    }

    public static String strm2str(InputStream inputStream, CharSet charSet, int n) throws SQLException {
        InputStreamReader inputStreamReader;
        try {
            inputStreamReader = charSet.getISR(inputStream);
        }
        catch (Exception exception) {
            throw SqlExFactory.get(ERR_GC401E_CHAR_ENCODE);
        }
        return SqlLongChar.strm2str(inputStreamReader, n);
    }
}

