/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.IdMap;
import com.ingres.gcf.util.SqlExFactory;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.Vector;

public class SqlDates
implements GcfErr {
    public static final String D_EPOCH = "1970-01-01";
    public static final String T_EPOCH = "00:00:00";
    public static final String TS_EPOCH = "1970-01-01 00:00:00";
    public static final String D_FMT = "yyyy-MM-dd";
    public static final String T_FMT = "HH:mm:ss";
    public static final String TS_FMT = "yyyy-MM-dd HH:mm:ss";
    public static final String D_LIT_FMT = "yyyy_MM_dd";
    public static final String T_LIT_FMT = "HH:mm:ss";
    public static final String TS_LIT_FMT = "yyyy_MM_dd HH:mm:ss";
    public static final String TZ_FMT = "+HH:mm";
    private static TimeZone tz_gmt = TimeZone.getTimeZone("GMT");
    private static TimeZone tz_lcl = TimeZone.getDefault();
    private static java.sql.Date epochDate = null;
    private static Time epochTime = null;
    private static Timestamp epochTS = null;
    private static Hashtable tzCache = new Hashtable();
    private static Vector tzoCache = new Vector();
    private static SqlDates dflt = new SqlDates(false);
    private DateFormat df_date;
    private DateFormat df_time;
    private DateFormat df_stamp;
    private static char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static char[] zeros = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0'};

    private SqlDates(boolean bl) {
        if (bl) {
            this.df_date = new SimpleDateFormat(D_LIT_FMT);
            this.df_time = new SimpleDateFormat("HH:mm:ss");
            this.df_stamp = new SimpleDateFormat(TS_LIT_FMT);
        } else {
            this.df_date = new SimpleDateFormat(D_FMT);
            this.df_time = new SimpleDateFormat("HH:mm:ss");
            this.df_stamp = new SimpleDateFormat(TS_FMT);
        }
    }

    public static SqlDates getDefaultInstance() {
        return dflt;
    }

    public static SqlDates getInstance() {
        return new SqlDates(false);
    }

    public static SqlDates getLiteralInstance() {
        return new SqlDates(true);
    }

    public static java.sql.Date getEpochDate() throws SQLException {
        if (epochDate == null) {
            epochDate = dflt.parseDate(D_EPOCH, tz_lcl);
        }
        return epochDate;
    }

    public static Time getEpochTime() throws SQLException {
        if (epochTime == null) {
            epochTime = dflt.parseTime(T_EPOCH, tz_lcl);
        }
        return epochTime;
    }

    public static Timestamp getEpochTimestamp() throws SQLException {
        if (epochTS == null) {
            epochTS = dflt.parseTimestamp(TS_EPOCH, tz_lcl);
        }
        return epochTS;
    }

    public TimeZone getTZ(int n) throws SQLException {
        return this.getTZ(this.formatOffset(n));
    }

    public TimeZone getTZ(String string) throws SQLException {
        TimeZone timeZone = (TimeZone)tzCache.get(string);
        if (timeZone == null) {
            int n = this.parseOffset(string);
            timeZone = new SimpleTimeZone(n * 60000, "GMT" + string);
            tzCache.put(string, timeZone);
        }
        return timeZone;
    }

    public int parseOffset(String string) throws SQLException {
        if (string.length() != TZ_FMT.length() || string.charAt(0) != '+' && string.charAt(0) != '-' || !Character.isDigit(string.charAt(1)) || !Character.isDigit(string.charAt(2)) || string.charAt(3) != ':' || !Character.isDigit(string.charAt(4)) || !Character.isDigit(string.charAt(5))) {
            throw SqlExFactory.get(ERR_GC401B_INVALID_DATE);
        }
        int n = Character.digit(string.charAt(1), 10) * 10 + Character.digit(string.charAt(2), 10);
        int n2 = Character.digit(string.charAt(4), 10) * 10 + Character.digit(string.charAt(5), 10);
        int n3 = n * 60 + n2;
        if (string.charAt(0) == '-') {
            n3 = -n3;
        }
        return n3;
    }

    public String formatOffset(int n) {
        int n2;
        String string = null;
        for (n2 = 0; n2 < tzoCache.size(); ++n2) {
            IdMap idMap = (IdMap)tzoCache.get(n2);
            if (!idMap.equals(n)) continue;
            string = idMap.toString();
            break;
        }
        if (string == null) {
            int n3 = n2 = n < 0 ? 1 : 0;
            if (n2 != 0) {
                n = -n;
            }
            int n4 = n / 60;
            int n5 = n % 60;
            char[] cArray = new char[]{n2 != 0 ? (char)'-' : '+', digits[n4 / 10 % 10], digits[n4 % 10], ':', digits[n5 / 10 % 10], digits[n5 % 10]};
            if (n2 != 0) {
                n = -n;
            }
            string = new String(cArray);
            tzoCache.add(new IdMap(n, string));
        }
        return string;
    }

    public String formatTZ(Date date) {
        return this.formatTZ(tz_lcl, date.getTime());
    }

    public String formatTZ(TimeZone timeZone, Date date) {
        return this.formatTZ(timeZone, date.getTime());
    }

    public String formatTZ(long l) {
        return this.formatTZ(tz_lcl, l);
    }

    public String formatTZ(TimeZone timeZone, long l) {
        return this.formatOffset(timeZone.getOffset(l) / 60000);
    }

    public int parseFrac(String string) throws SQLException {
        int n = 0;
        if (string.length() < 1 || string.charAt(0) != '.') {
            throw SqlExFactory.get(ERR_GC401B_INVALID_DATE);
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (stringBuffer.length() > 10) {
            stringBuffer.setLength(10);
        }
        if (stringBuffer.length() < 10) {
            stringBuffer.append(zeros, 0, 10 - stringBuffer.length());
        }
        try {
            n = Integer.parseInt(stringBuffer.substring(1));
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401B_INVALID_DATE);
        }
        return n;
    }

    public String formatFrac(int n) {
        if (n == 0) {
            return ".0";
        }
        if (n < 0) {
            n = -n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = Integer.toString(n);
        stringBuffer.append('.');
        if (string.length() < 9) {
            stringBuffer.append(zeros, 0, 9 - string.length());
        }
        stringBuffer.append(string);
        int n2 = 10;
        while (stringBuffer.charAt(n2 - 1) == '0') {
            --n2;
        }
        stringBuffer.setLength(n2);
        return stringBuffer.toString();
    }

    public Time parseTime(String string, boolean bl) throws SQLException {
        return this.parseTime(string, bl ? tz_gmt : tz_lcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time parseTime(String string, TimeZone timeZone) throws SQLException {
        Date date;
        if (string.length() != "HH:mm:ss".length()) {
            throw SqlExFactory.get(ERR_GC401B_INVALID_DATE);
        }
        DateFormat dateFormat = this.df_time;
        synchronized (dateFormat) {
            this.df_time.setTimeZone(timeZone);
            try {
                date = this.df_time.parse(string);
            }
            catch (Exception exception) {
                throw SqlExFactory.get(ERR_GC401B_INVALID_DATE);
            }
        }
        return new Time(date.getTime());
    }

    public String formatTime(Date date, boolean bl) {
        return this.formatTime(date, bl ? tz_gmt : tz_lcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formatTime(Date date, TimeZone timeZone) {
        String string;
        DateFormat dateFormat = this.df_time;
        synchronized (dateFormat) {
            this.df_time.setTimeZone(timeZone);
            string = this.df_time.format(date);
        }
        return string;
    }

    public java.sql.Date parseDate(String string, boolean bl) throws SQLException {
        return this.parseDate(string, bl ? tz_gmt : tz_lcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.Date parseDate(String string, TimeZone timeZone) throws SQLException {
        Date date;
        if (string.length() != D_FMT.length()) {
            throw SqlExFactory.get(ERR_GC401B_INVALID_DATE);
        }
        DateFormat dateFormat = this.df_date;
        synchronized (dateFormat) {
            this.df_date.setTimeZone(timeZone);
            try {
                date = this.df_date.parse(string);
            }
            catch (Exception exception) {
                throw SqlExFactory.get(ERR_GC401B_INVALID_DATE);
            }
        }
        return new java.sql.Date(date.getTime());
    }

    public String formatDate(Date date, boolean bl) {
        return this.formatDate(date, bl ? tz_gmt : tz_lcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formatDate(Date date, TimeZone timeZone) {
        String string;
        DateFormat dateFormat = this.df_date;
        synchronized (dateFormat) {
            this.df_date.setTimeZone(timeZone);
            string = this.df_date.format(date);
        }
        return string;
    }

    public Timestamp parseTimestamp(String string, boolean bl) throws SQLException {
        return this.parseTimestamp(string, bl ? tz_gmt : tz_lcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp parseTimestamp(String string, TimeZone timeZone) throws SQLException {
        Date date;
        if (string.length() != TS_FMT.length()) {
            throw SqlExFactory.get(ERR_GC401B_INVALID_DATE);
        }
        DateFormat dateFormat = this.df_stamp;
        synchronized (dateFormat) {
            this.df_stamp.setTimeZone(timeZone);
            try {
                date = this.df_stamp.parse(string);
            }
            catch (Exception exception) {
                throw SqlExFactory.get(ERR_GC401B_INVALID_DATE);
            }
        }
        return new Timestamp(date.getTime());
    }

    public String formatTimestamp(Date date, boolean bl) {
        return this.formatTimestamp(date, bl ? tz_gmt : tz_lcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formatTimestamp(Date date, TimeZone timeZone) {
        String string;
        DateFormat dateFormat = this.df_stamp;
        synchronized (dateFormat) {
            this.df_stamp.setTimeZone(timeZone);
            string = this.df_stamp.format(date);
        }
        return string;
    }
}

